/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.jsr166e;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import jersey.repackaged.jsr166e.ThreadLocalRandom;
import sun.misc.Unsafe;

public class StampedLock
implements Serializable {
    private static final long serialVersionUID = -6001602636862214147L;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int SPINS = NCPU > 1 ? 64 : 0;
    private static final int HEAD_SPINS = NCPU > 1 ? 1024 : 0;
    private static final int MAX_HEAD_SPINS = NCPU > 1 ? 65536 : 0;
    private static final int OVERFLOW_YIELD_RATE = 7;
    private static final int LG_READERS = 7;
    private static final long RUNIT = 1L;
    private static final long WBIT = 128L;
    private static final long RBITS = 127L;
    private static final long RFULL = 126L;
    private static final long ABITS = 255L;
    private static final long SBITS = -128L;
    private static final long ORIGIN = 256L;
    private static final long INTERRUPTED = 1L;
    private static final int WAITING = -1;
    private static final int CANCELLED = 1;
    private static final int RMODE = 0;
    private static final int WMODE = 1;
    private volatile transient WNode whead;
    private volatile transient WNode wtail;
    transient ReadLockView readLockView;
    transient WriteLockView writeLockView;
    transient ReadWriteLockView readWriteLockView;
    private volatile transient long state = 256L;
    private transient int readerOverflow;
    private static final Unsafe U;
    private static final long STATE;
    private static final long WHEAD;
    private static final long WTAIL;
    private static final long WNEXT;
    private static final long WSTATUS;
    private static final long WCOWAIT;
    private static final long PARKBLOCKER;

    public long writeLock() {
        long next;
        long s = this.state;
        return (s & 0xFFL) == 0L && U.compareAndSwapLong(this, STATE, s, next = s + 128L) ? next : this.acquireWrite(false, 0L);
    }

    public long tryWriteLock() {
        long next;
        long s = this.state;
        return (s & 0xFFL) == 0L && U.compareAndSwapLong(this, STATE, s, next = s + 128L) ? next : 0L;
    }

    public long tryWriteLock(long time, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(time);
        if (!Thread.interrupted()) {
            long next = this.tryWriteLock();
            if (next != 0L) {
                return next;
            }
            if (nanos <= 0L) {
                return 0L;
            }
            long deadline = System.nanoTime() + nanos;
            if (deadline == 0L) {
                deadline = 1L;
            }
            if ((next = this.acquireWrite(true, deadline)) != 1L) {
                return next;
            }
        }
        throw new InterruptedException();
    }

    public long writeLockInterruptibly() throws InterruptedException {
        long next;
        if (!Thread.interrupted() && (next = this.acquireWrite(true, 0L)) != 1L) {
            return next;
        }
        throw new InterruptedException();
    }

    public long readLock() {
        long next;
        long s = this.state;
        return this.whead == this.wtail && (s & 0xFFL) < 126L && U.compareAndSwapLong(this, STATE, s, next = s + 1L) ? next : this.acquireRead(false, 0L);
    }

    public long tryReadLock() {
        long next;
        long s;
        long m;
        do {
            if ((m = (s = this.state) & 0xFFL) != 128L) continue;
            return 0L;
        } while (!(m < 126L ? U.compareAndSwapLong(this, STATE, s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L));
        return next;
    }

    public long tryReadLock(long time, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(time);
        if (!Thread.interrupted()) {
            long next;
            long s = this.state;
            long m = s & 0xFFL;
            if (m != 128L && (m < 126L ? U.compareAndSwapLong(this, STATE, s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L)) {
                return next;
            }
            if (nanos <= 0L) {
                return 0L;
            }
            long deadline = System.nanoTime() + nanos;
            if (deadline == 0L) {
                deadline = 1L;
            }
            if ((next = this.acquireRead(true, deadline)) != 1L) {
                return next;
            }
        }
        throw new InterruptedException();
    }

    public long readLockInterruptibly() throws InterruptedException {
        long next;
        if (!Thread.interrupted() && (next = this.acquireRead(true, 0L)) != 1L) {
            return next;
        }
        throw new InterruptedException();
    }

    public long tryOptimisticRead() {
        long s = this.state;
        return (s & 0x80L) == 0L ? s & 0xFFFFFFFFFFFFFF80L : 0L;
    }

    public boolean validate(long stamp) {
        return (stamp & 0xFFFFFFFFFFFFFF80L) == (U.getLongVolatile(this, STATE) & 0xFFFFFFFFFFFFFF80L);
    }

    public void unlockWrite(long stamp) {
        if (this.state != stamp || (stamp & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.state = (stamp += 128L) == 0L ? 256L : stamp;
        WNode h = this.whead;
        if (h != null && h.status != 0) {
            this.release(h);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlockRead(long stamp) {
        while (true) {
            long m;
            long s;
            if (((s = this.state) & 0xFFFFFFFFFFFFFF80L) != (stamp & 0xFFFFFFFFFFFFFF80L) || (stamp & 0xFFL) == 0L || (m = s & 0xFFL) == 0L || m == 128L) {
                throw new IllegalMonitorStateException();
            }
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m != 1L || (h = this.whead) == null || h.status == 0) return;
                this.release(h);
                return;
            }
            if (this.tryDecReaderOverflow(s) != 0L) return;
        }
    }

    public void unlock(long stamp) {
        long m;
        long s;
        long a = stamp & 0xFFL;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L) && (m = s & 0xFFL) != 0L) {
            if (m == 128L) {
                if (a != m) break;
                this.state = (s += 128L) == 0L ? 256L : s;
                WNode h = this.whead;
                if (h != null && h.status != 0) {
                    this.release(h);
                }
                return;
            }
            if (a == 0L || a >= 128L) break;
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return;
            }
            if (this.tryDecReaderOverflow(s) == 0L) continue;
            return;
        }
        throw new IllegalMonitorStateException();
    }

    public long tryConvertToWriteLock(long stamp) {
        long s;
        long a = stamp & 0xFFL;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long m = s & 0xFFL;
            if (m == 0L) {
                if (a != 0L) break;
                next = s + 128L;
                if (!U.compareAndSwapLong(this, STATE, s, next)) continue;
                return next;
            }
            if (m == 128L) {
                if (a != m) break;
                return stamp;
            }
            if (m != 1L || a == 0L) break;
            next = s - 1L + 128L;
            if (!U.compareAndSwapLong(this, STATE, s, next)) continue;
            return next;
        }
        return 0L;
    }

    public long tryConvertToReadLock(long stamp) {
        long s;
        long a = stamp & 0xFFL;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long m = s & 0xFFL;
            if (m == 0L) {
                if (a != 0L) break;
                if (!(m < 126L ? U.compareAndSwapLong(this, STATE, s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L)) continue;
                return next;
            }
            if (m == 128L) {
                if (a != m) break;
                this.state = next = s + 129L;
                WNode h = this.whead;
                if (h != null && h.status != 0) {
                    this.release(h);
                }
                return next;
            }
            if (a == 0L || a >= 128L) break;
            return stamp;
        }
        return 0L;
    }

    public long tryConvertToOptimisticRead(long stamp) {
        block8: {
            long next;
            long a = stamp & 0xFFL;
            while (true) {
                long s = U.getLongVolatile(this, STATE);
                s = this.state;
                if ((s & 0xFFFFFFFFFFFFFF80L) != (stamp & 0xFFFFFFFFFFFFFF80L)) break block8;
                long m = s & 0xFFL;
                if (m == 0L) {
                    if (a == 0L) {
                        return s;
                    }
                    break block8;
                }
                if (m == 128L) {
                    if (a == m) {
                        next = (s += 128L) == 0L ? 256L : s;
                        this.state = next;
                        WNode h = this.whead;
                        if (h != null && h.status != 0) {
                            this.release(h);
                        }
                        return next;
                    }
                    break block8;
                }
                if (a == 0L || a >= 128L) break block8;
                if (m < 126L) {
                    WNode h;
                    next = s - 1L;
                    if (!U.compareAndSwapLong(this, STATE, s, next)) continue;
                    if (m == 1L && (h = this.whead) != null && h.status != 0) {
                        this.release(h);
                    }
                    return next & 0xFFFFFFFFFFFFFF80L;
                }
                next = this.tryDecReaderOverflow(s);
                if (next != 0L) break;
            }
            return next & 0xFFFFFFFFFFFFFF80L;
        }
        return 0L;
    }

    public boolean tryUnlockWrite() {
        long s = this.state;
        if ((s & 0x80L) != 0L) {
            this.state = (s += 128L) == 0L ? 256L : s;
            WNode h = this.whead;
            if (h != null && h.status != 0) {
                this.release(h);
            }
            return true;
        }
        return false;
    }

    public boolean tryUnlockRead() {
        long s;
        long m;
        while ((m = (s = this.state) & 0xFFL) != 0L && m < 128L) {
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return true;
            }
            if (this.tryDecReaderOverflow(s) == 0L) continue;
            return true;
        }
        return false;
    }

    private int getReadLockCount(long s) {
        long readers = s & 0x7FL;
        if (readers >= 126L) {
            readers = 126L + (long)this.readerOverflow;
        }
        return (int)readers;
    }

    public boolean isWriteLocked() {
        return (this.state & 0x80L) != 0L;
    }

    public boolean isReadLocked() {
        return (this.state & 0x7FL) != 0L;
    }

    public int getReadLockCount() {
        return this.getReadLockCount(this.state);
    }

    public String toString() {
        long s = this.state;
        return super.toString() + ((s & 0xFFL) == 0L ? "[Unlocked]" : ((s & 0x80L) != 0L ? "[Write-locked]" : "[Read-locks:" + this.getReadLockCount(s) + "]"));
    }

    public Lock asReadLock() {
        ReadLockView v = this.readLockView;
        return v != null ? v : (this.readLockView = new ReadLockView());
    }

    public Lock asWriteLock() {
        WriteLockView v = this.writeLockView;
        return v != null ? v : (this.writeLockView = new WriteLockView());
    }

    public ReadWriteLock asReadWriteLock() {
        ReadWriteLockView v = this.readWriteLockView;
        return v != null ? v : (this.readWriteLockView = new ReadWriteLockView());
    }

    final void unstampedUnlockWrite() {
        long s = this.state;
        if ((s & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.state = (s += 128L) == 0L ? 256L : s;
        WNode h = this.whead;
        if (h != null && h.status != 0) {
            this.release(h);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void unstampedUnlockRead() {
        while (true) {
            long s;
            long m;
            if ((m = (s = this.state) & 0xFFL) == 0L || m >= 128L) {
                throw new IllegalMonitorStateException();
            }
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m != 1L || (h = this.whead) == null || h.status == 0) return;
                this.release(h);
                return;
            }
            if (this.tryDecReaderOverflow(s) != 0L) return;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.state = 256L;
    }

    private long tryIncReaderOverflow(long s) {
        if ((s & 0xFFL) == 126L) {
            if (U.compareAndSwapLong(this, STATE, s, s | 0x7FL)) {
                ++this.readerOverflow;
                this.state = s;
                return s;
            }
        } else if ((ThreadLocalRandom.current().nextInt() & 7) == 0) {
            Thread.yield();
        }
        return 0L;
    }

    private long tryDecReaderOverflow(long s) {
        if ((s & 0xFFL) == 126L) {
            if (U.compareAndSwapLong(this, STATE, s, s | 0x7FL)) {
                long next;
                int r = this.readerOverflow;
                if (r > 0) {
                    this.readerOverflow = r - 1;
                    next = s;
                } else {
                    next = s - 1L;
                }
                this.state = next;
                return next;
            }
        } else if ((ThreadLocalRandom.current().nextInt() & 7) == 0) {
            Thread.yield();
        }
        return 0L;
    }

    private void release(WNode h) {
        if (h != null) {
            Thread w;
            U.compareAndSwapInt(h, WSTATUS, -1, 0);
            WNode q = h.next;
            if (q == null || q.status == 1) {
                WNode t = this.wtail;
                while (t != null && t != h) {
                    if (t.status <= 0) {
                        q = t;
                    }
                    t = t.prev;
                }
            }
            if (q != null && (w = q.thread) != null) {
                U.unpark(w);
            }
        }
    }

    private long acquireWrite(boolean interruptible, long deadline) {
        WNode p;
        WNode node = null;
        int spins = -1;
        while (true) {
            long s;
            long m;
            if ((m = (s = this.state) & 0xFFL) == 0L) {
                long ns = s + 128L;
                if (!U.compareAndSwapLong(this, STATE, s, ns)) continue;
                return ns;
            }
            if (spins < 0) {
                spins = m == 128L && this.wtail == this.whead ? SPINS : 0;
                continue;
            }
            if (spins > 0) {
                if (ThreadLocalRandom.current().nextInt() < 0) continue;
                --spins;
                continue;
            }
            p = this.wtail;
            if (p == null) {
                WNode hd = new WNode(1, null);
                if (!U.compareAndSwapObject(this, WHEAD, null, hd)) continue;
                this.wtail = hd;
                continue;
            }
            if (node == null) {
                node = new WNode(1, p);
                continue;
            }
            if (node.prev != p) {
                node.prev = p;
                continue;
            }
            if (U.compareAndSwapObject(this, WTAIL, p, node)) break;
        }
        p.next = node;
        spins = -1;
        while (true) {
            long time;
            WNode h;
            if ((h = this.whead) == p) {
                if (spins < 0) {
                    spins = HEAD_SPINS;
                } else if (spins < MAX_HEAD_SPINS) {
                    spins <<= 1;
                }
                int k = spins;
                while (true) {
                    long s;
                    if (((s = this.state) & 0xFFL) == 0L) {
                        long ns = s + 128L;
                        if (!U.compareAndSwapLong(this, STATE, s, ns)) continue;
                        this.whead = node;
                        node.prev = null;
                        return ns;
                    }
                    if (ThreadLocalRandom.current().nextInt() >= 0 && --k <= 0) break;
                }
            } else if (h != null) {
                WNode c;
                while ((c = h.cowait) != null) {
                    Thread w;
                    if (!U.compareAndSwapObject(h, WCOWAIT, c, c.cowait) || (w = c.thread) == null) continue;
                    U.unpark(w);
                }
            }
            if (this.whead != h) continue;
            WNode np = node.prev;
            if (np != p) {
                if (np == null) continue;
                p = np;
                np.next = node;
                continue;
            }
            int ps = p.status;
            if (ps == 0) {
                U.compareAndSwapInt(p, WSTATUS, 0, -1);
                continue;
            }
            if (ps == 1) {
                WNode pp = p.prev;
                if (pp == null) continue;
                node.prev = pp;
                pp.next = node;
                continue;
            }
            if (deadline == 0L) {
                time = 0L;
            } else {
                time = deadline - System.nanoTime();
                if (time <= 0L) {
                    return this.cancelWaiter(node, node, false);
                }
            }
            Thread wt = Thread.currentThread();
            U.putObject(wt, PARKBLOCKER, this);
            node.thread = wt;
            if (p.status < 0 && (p != h || (this.state & 0xFFL) != 0L) && this.whead == h && node.prev == p) {
                U.park(false, time);
            }
            node.thread = null;
            U.putObject(wt, PARKBLOCKER, null);
            if (interruptible && Thread.interrupted()) break;
        }
        return this.cancelWaiter(node, node, true);
    }

    private long acquireRead(boolean interruptible, long deadline) {
        WNode p;
        WNode h;
        int spins;
        WNode node;
        block37: {
            node = null;
            spins = -1;
            block0: while (true) {
                if ((h = this.whead) == (p = this.wtail)) {
                    while (true) {
                        long ns;
                        long s;
                        long m;
                        if ((m = (s = this.state) & 0xFFL) < 126L ? U.compareAndSwapLong(this, STATE, s, ns = s + 1L) : m < 128L && (ns = this.tryIncReaderOverflow(s)) != 0L) {
                            return ns;
                        }
                        if (m < 128L) continue;
                        if (spins > 0) {
                            if (ThreadLocalRandom.current().nextInt() < 0) continue;
                            --spins;
                            continue;
                        }
                        if (spins == 0) {
                            WNode nh = this.whead;
                            WNode np = this.wtail;
                            if (nh == h && np == p || (h = nh) != (p = np)) break;
                        }
                        spins = SPINS;
                    }
                }
                if (p == null) {
                    WNode hd = new WNode(1, null);
                    if (!U.compareAndSwapObject(this, WHEAD, null, hd)) continue;
                    this.wtail = hd;
                    continue;
                }
                if (node == null) {
                    node = new WNode(0, p);
                    continue;
                }
                if (h == p || p.mode != 0) {
                    if (node.prev != p) {
                        node.prev = p;
                        continue;
                    }
                    if (!U.compareAndSwapObject(this, WTAIL, p, node)) continue;
                    break block37;
                }
                node.cowait = p.cowait;
                if (!U.compareAndSwapObject(p, WCOWAIT, node.cowait, node)) {
                    node.cowait = null;
                    continue;
                }
                while (true) {
                    long time;
                    WNode pp;
                    Thread w;
                    WNode c;
                    if ((h = this.whead) != null && (c = h.cowait) != null && U.compareAndSwapObject(h, WCOWAIT, c, c.cowait) && (w = c.thread) != null) {
                        U.unpark(w);
                    }
                    if (h == (pp = p.prev) || h == p || pp == null) {
                        long m;
                        do {
                            long ns;
                            long s;
                            if (!((m = (s = this.state) & 0xFFL) < 126L ? U.compareAndSwapLong(this, STATE, s, ns = s + 1L) : m < 128L && (ns = this.tryIncReaderOverflow(s)) != 0L)) continue;
                            return ns;
                        } while (m < 128L);
                    }
                    if (this.whead != h || p.prev != pp) continue;
                    if (pp == null || h == p || p.status > 0) {
                        node = null;
                        continue block0;
                    }
                    if (deadline == 0L) {
                        time = 0L;
                    } else {
                        time = deadline - System.nanoTime();
                        if (time <= 0L) {
                            return this.cancelWaiter(node, p, false);
                        }
                    }
                    Thread wt = Thread.currentThread();
                    U.putObject(wt, PARKBLOCKER, this);
                    node.thread = wt;
                    if ((h != pp || (this.state & 0xFFL) == 128L) && this.whead == h && p.prev == pp) {
                        U.park(false, time);
                    }
                    node.thread = null;
                    U.putObject(wt, PARKBLOCKER, null);
                    if (interruptible && Thread.interrupted()) break block0;
                }
                break;
            }
            return this.cancelWaiter(node, p, true);
        }
        p.next = node;
        spins = -1;
        while (true) {
            long time;
            if ((h = this.whead) == p) {
                long m;
                if (spins < 0) {
                    spins = HEAD_SPINS;
                } else if (spins < MAX_HEAD_SPINS) {
                    spins <<= 1;
                }
                int k = spins;
                do {
                    WNode c;
                    long ns;
                    long s;
                    if (!((m = (s = this.state) & 0xFFL) < 126L ? U.compareAndSwapLong(this, STATE, s, ns = s + 1L) : m < 128L && (ns = this.tryIncReaderOverflow(s)) != 0L)) continue;
                    this.whead = node;
                    node.prev = null;
                    while ((c = node.cowait) != null) {
                        Thread w;
                        if (!U.compareAndSwapObject(node, WCOWAIT, c, c.cowait) || (w = c.thread) == null) continue;
                        U.unpark(w);
                    }
                    return ns;
                } while (m < 128L || ThreadLocalRandom.current().nextInt() < 0 || --k > 0);
            } else if (h != null) {
                WNode c;
                while ((c = h.cowait) != null) {
                    Thread w;
                    if (!U.compareAndSwapObject(h, WCOWAIT, c, c.cowait) || (w = c.thread) == null) continue;
                    U.unpark(w);
                }
            }
            if (this.whead != h) continue;
            WNode np = node.prev;
            if (np != p) {
                if (np == null) continue;
                p = np;
                np.next = node;
                continue;
            }
            int ps = p.status;
            if (ps == 0) {
                U.compareAndSwapInt(p, WSTATUS, 0, -1);
                continue;
            }
            if (ps == 1) {
                WNode pp = p.prev;
                if (pp == null) continue;
                node.prev = pp;
                pp.next = node;
                continue;
            }
            if (deadline == 0L) {
                time = 0L;
            } else {
                time = deadline - System.nanoTime();
                if (time <= 0L) {
                    return this.cancelWaiter(node, node, false);
                }
            }
            Thread wt = Thread.currentThread();
            U.putObject(wt, PARKBLOCKER, this);
            node.thread = wt;
            if (p.status < 0 && (p != h || (this.state & 0xFFL) == 128L) && this.whead == h && node.prev == p) {
                U.park(false, time);
            }
            node.thread = null;
            U.putObject(wt, PARKBLOCKER, null);
            if (interruptible && Thread.interrupted()) break;
        }
        return this.cancelWaiter(node, node, true);
    }

    private long cancelWaiter(WNode node, WNode group, boolean interrupted) {
        WNode h;
        if (node != null && group != null) {
            WNode q;
            node.status = 1;
            WNode p = group;
            while ((q = p.cowait) != null) {
                if (q.status == 1) {
                    U.compareAndSwapObject(p, WCOWAIT, q, q.cowait);
                    p = group;
                    continue;
                }
                p = q;
            }
            if (group == node) {
                Thread w;
                WNode r = group.cowait;
                while (r != null) {
                    w = r.thread;
                    if (w != null) {
                        U.unpark(w);
                    }
                    r = r.cowait;
                }
                WNode pred = node.prev;
                while (pred != null) {
                    WNode pp;
                    WNode succ;
                    while ((succ = node.next) == null || succ.status == 1) {
                        WNode q2 = null;
                        WNode t = this.wtail;
                        while (t != null && t != node) {
                            if (t.status != 1) {
                                q2 = t;
                            }
                            t = t.prev;
                        }
                        if (succ != q2 && !U.compareAndSwapObject(node, WNEXT, succ, succ = q2)) continue;
                        if (succ != null || node != this.wtail) break;
                        U.compareAndSwapObject(this, WTAIL, node, pred);
                        break;
                    }
                    if (pred.next == node) {
                        U.compareAndSwapObject(pred, WNEXT, node, succ);
                    }
                    if (succ != null && (w = succ.thread) != null) {
                        succ.thread = null;
                        U.unpark(w);
                    }
                    if (pred.status != 1 || (pp = pred.prev) == null) break;
                    node.prev = pp;
                    U.compareAndSwapObject(pp, WNEXT, pred, succ);
                    pred = pp;
                }
            }
        }
        while ((h = this.whead) != null) {
            long s;
            WNode q = h.next;
            if (q == null || q.status == 1) {
                WNode t = this.wtail;
                while (t != null && t != h) {
                    if (t.status <= 0) {
                        q = t;
                    }
                    t = t.prev;
                }
            }
            if (h != this.whead) continue;
            if (q == null || h.status != 0 || ((s = this.state) & 0xFFL) == 128L || s != 0L && q.mode != 0) break;
            this.release(h);
            break;
        }
        return interrupted || Thread.interrupted() ? 1L : 0L;
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        try {
            U = StampedLock.getUnsafe();
            Class<StampedLock> k = StampedLock.class;
            Class<WNode> wk = WNode.class;
            STATE = U.objectFieldOffset(k.getDeclaredField("state"));
            WHEAD = U.objectFieldOffset(k.getDeclaredField("whead"));
            WTAIL = U.objectFieldOffset(k.getDeclaredField("wtail"));
            WSTATUS = U.objectFieldOffset(wk.getDeclaredField("status"));
            WNEXT = U.objectFieldOffset(wk.getDeclaredField("next"));
            WCOWAIT = U.objectFieldOffset(wk.getDeclaredField("cowait"));
            Class<Thread> tk = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(tk.getDeclaredField("parkBlocker"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    final class ReadWriteLockView
    implements ReadWriteLock {
        ReadWriteLockView() {
        }

        @Override
        public Lock readLock() {
            return StampedLock.this.asReadLock();
        }

        @Override
        public Lock writeLock() {
            return StampedLock.this.asWriteLock();
        }
    }

    final class WriteLockView
    implements Lock {
        WriteLockView() {
        }

        @Override
        public void lock() {
            StampedLock.this.writeLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            StampedLock.this.writeLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryWriteLock() != 0L;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return StampedLock.this.tryWriteLock(time, unit) != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockWrite();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    final class ReadLockView
    implements Lock {
        ReadLockView() {
        }

        @Override
        public void lock() {
            StampedLock.this.readLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            StampedLock.this.readLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryReadLock() != 0L;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return StampedLock.this.tryReadLock(time, unit) != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockRead();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    static final class WNode {
        volatile WNode prev;
        volatile WNode next;
        volatile WNode cowait;
        volatile Thread thread;
        volatile int status;
        final int mode;

        WNode(int m, WNode p) {
            this.mode = m;
            this.prev = p;
        }
    }
}

