/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UpdateClassifierOptions
extends GenericModel {
    private String classifierId;
    private Map<String, File> classnamePositiveExamples;
    private InputStream negativeExamples;
    private String negativeExamplesFilename;

    private UpdateClassifierOptions(Builder builder) {
        Validator.notEmpty(builder.classifierId, "classifierId cannot be empty");
        Validator.isTrue(!builder.classnamePositiveExamples.isEmpty() || builder.negativeExamples != null, "To update a classifier, you must supply at least one positive examples file or a negative examples file.");
        Validator.isTrue(builder.negativeExamples == null || builder.negativeExamplesFilename != null, "negativeExamplesFilename cannot be null if negativeExamples is not null.");
        this.classifierId = builder.classifierId;
        this.classnamePositiveExamples = builder.classnamePositiveExamples;
        this.negativeExamples = builder.negativeExamples;
        this.negativeExamplesFilename = builder.negativeExamplesFilename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String classifierId() {
        return this.classifierId;
    }

    public Set<String> classNames() {
        return this.classnamePositiveExamples.keySet();
    }

    public File positiveExamplesByClassName(String className) {
        return this.classnamePositiveExamples.get(className);
    }

    public InputStream negativeExamples() {
        return this.negativeExamples;
    }

    public String negativeExamplesFilename() {
        return this.negativeExamplesFilename;
    }

    public static class Builder {
        private String classifierId;
        private Map<String, File> classnamePositiveExamples;
        private InputStream negativeExamples;
        private String negativeExamplesFilename;

        private Builder(UpdateClassifierOptions updateClassifierOptions) {
            this.classifierId = updateClassifierOptions.classifierId;
            this.classnamePositiveExamples.putAll(updateClassifierOptions.classnamePositiveExamples);
            this.negativeExamples = updateClassifierOptions.negativeExamples;
            this.negativeExamplesFilename = updateClassifierOptions.negativeExamplesFilename;
        }

        public Builder() {
            this.classnamePositiveExamples = new HashMap<String, File>();
        }

        public Builder(String classifierId) {
            this();
            this.classifierId = classifierId;
        }

        public UpdateClassifierOptions build() {
            return new UpdateClassifierOptions(this);
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder addClass(String className, File positiveExamples) {
            Validator.notNull(className, "'className' cannot be null");
            Validator.notNull(positiveExamples, "'positiveExamples' cannot be null");
            this.classnamePositiveExamples.put(className, positiveExamples);
            return this;
        }

        public Builder negativeExamples(InputStream negativeExamples) {
            this.negativeExamples = negativeExamples;
            return this;
        }

        public Builder negativeExamplesFilename(String negativeExamplesFilename) {
            this.negativeExamplesFilename = negativeExamplesFilename;
            return this;
        }

        public Builder negativeExamples(File negativeExamples) throws FileNotFoundException {
            this.negativeExamples = new FileInputStream(negativeExamples);
            this.negativeExamplesFilename = negativeExamples.getName();
            return this;
        }
    }
}

