/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CreateClassifierOptions
extends GenericModel {
    private String name;
    private Map<String, File> classnamePositiveExamples;
    private InputStream negativeExamples;
    private String negativeExamplesFilename;

    private CreateClassifierOptions(Builder builder) {
        Validator.notNull(builder.name, "name cannot be null");
        Validator.isTrue(!builder.classnamePositiveExamples.isEmpty(), "To create a classifier, you must supply at least one positive examples file.");
        this.name = builder.name;
        this.classnamePositiveExamples = builder.classnamePositiveExamples;
        this.negativeExamples = builder.negativeExamples;
        this.negativeExamplesFilename = builder.negativeExamplesFilename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public Set<String> classNames() {
        return this.classnamePositiveExamples.keySet();
    }

    public File positiveExamplesByClassName(String className) {
        return this.classnamePositiveExamples.get(className);
    }

    public InputStream negativeExamples() {
        return this.negativeExamples;
    }

    public String negativeExamplesFilename() {
        return this.negativeExamplesFilename;
    }

    public static class Builder {
        private String name;
        private Map<String, File> classnamePositiveExamples;
        private InputStream negativeExamples;
        private String negativeExamplesFilename;

        private Builder(CreateClassifierOptions createClassifierOptions) {
            this.name = createClassifierOptions.name;
            this.classnamePositiveExamples.putAll(createClassifierOptions.classnamePositiveExamples);
            this.negativeExamples = createClassifierOptions.negativeExamples;
            this.negativeExamplesFilename = createClassifierOptions.negativeExamplesFilename;
        }

        public Builder() {
            this.classnamePositiveExamples = new HashMap<String, File>();
        }

        public Builder(String name) {
            this();
            this.name = name;
        }

        public CreateClassifierOptions build() {
            return new CreateClassifierOptions(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addClass(String className, File positiveExamples) {
            Validator.notNull(className, "className cannot be null");
            Validator.notNull(positiveExamples, "positiveExamples cannot be null");
            this.classnamePositiveExamples.put(className, positiveExamples);
            return this;
        }

        public Builder negativeExamples(InputStream negativeExamples) {
            this.negativeExamples = negativeExamples;
            return this;
        }

        public Builder negativeExamplesFilename(String negativeExamplesFilename) {
            this.negativeExamplesFilename = negativeExamplesFilename;
            return this;
        }

        public Builder negativeExamples(File negativeExamples) throws FileNotFoundException {
            this.negativeExamples = new FileInputStream(negativeExamples);
            this.negativeExamplesFilename = negativeExamples.getName();
            return this;
        }
    }
}

