/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ClassifyOptions
extends GenericModel {
    private InputStream imagesFile;
    private String imagesFilename;
    private String acceptLanguage;
    private String url;
    private Float threshold;
    private List<String> owners;
    private List<String> classifierIds;
    private String imagesFileContentType;
    @Deprecated
    private String parameters;

    private ClassifyOptions(Builder builder) {
        this.imagesFile = builder.imagesFile;
        this.imagesFilename = builder.imagesFilename;
        this.acceptLanguage = builder.acceptLanguage;
        this.url = builder.url;
        this.threshold = builder.threshold;
        this.owners = builder.owners;
        this.classifierIds = builder.classifierIds;
        this.imagesFileContentType = builder.imagesFileContentType;
        this.parameters = builder.parameters;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream imagesFile() {
        return this.imagesFile;
    }

    public String imagesFilename() {
        return this.imagesFilename;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String url() {
        return this.url;
    }

    public Float threshold() {
        return this.threshold;
    }

    public List<String> owners() {
        return this.owners;
    }

    public List<String> classifierIds() {
        return this.classifierIds;
    }

    public String imagesFileContentType() {
        return this.imagesFileContentType;
    }

    public String parameters() {
        return this.parameters;
    }

    public static class Builder {
        private InputStream imagesFile;
        private String imagesFilename;
        private String acceptLanguage;
        private String url;
        private Float threshold;
        private List<String> owners;
        private List<String> classifierIds;
        private String imagesFileContentType;
        @Deprecated
        private String parameters;

        private Builder(ClassifyOptions classifyOptions) {
            this.imagesFile = classifyOptions.imagesFile;
            this.imagesFilename = classifyOptions.imagesFilename;
            this.acceptLanguage = classifyOptions.acceptLanguage;
            this.url = classifyOptions.url;
            this.threshold = classifyOptions.threshold;
            this.owners = classifyOptions.owners;
            this.classifierIds = classifyOptions.classifierIds;
            this.imagesFileContentType = classifyOptions.imagesFileContentType;
            this.parameters = classifyOptions.parameters;
        }

        public Builder() {
        }

        public ClassifyOptions build() {
            return new ClassifyOptions(this);
        }

        public Builder addOwner(String owner) {
            Validator.notNull(owner, "owner cannot be null");
            if (this.owners == null) {
                this.owners = new ArrayList<String>();
            }
            this.owners.add(owner);
            return this;
        }

        public Builder addClassifierId(String classifierId) {
            Validator.notNull(classifierId, "classifierId cannot be null");
            if (this.classifierIds == null) {
                this.classifierIds = new ArrayList<String>();
            }
            this.classifierIds.add(classifierId);
            return this;
        }

        public Builder imagesFile(InputStream imagesFile) {
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder imagesFilename(String imagesFilename) {
            this.imagesFilename = imagesFilename;
            return this;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder owners(List<String> owners) {
            this.owners = owners;
            return this;
        }

        public Builder classifierIds(List<String> classifierIds) {
            this.classifierIds = classifierIds;
            return this;
        }

        public Builder imagesFileContentType(String imagesFileContentType) {
            this.imagesFileContentType = imagesFileContentType;
            return this;
        }

        public Builder imagesFile(File imagesFile) throws FileNotFoundException {
            this.imagesFile = new FileInputStream(imagesFile);
            this.imagesFilename = imagesFile.getName();
            return this;
        }

        public Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }
    }

    public static interface AcceptLanguage {
        public static final String EN = "en";
        public static final String AR = "ar";
        public static final String DE = "de";
        public static final String ES = "es";
        public static final String FR = "fr";
        public static final String IT = "it";
        public static final String JA = "ja";
        public static final String KO = "ko";
        public static final String PT_BR = "pt-br";
        public static final String ZH_CN = "zh-cn";
        public static final String ZH_TW = "zh-tw";
    }
}

