/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifiedImages;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.Classifier;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.Classifiers;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifyOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.CreateClassifierOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DeleteClassifierOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DeleteUserDataOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectFacesOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectedFaces;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.GetClassifierOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.GetCoreMlModelOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ListClassifiersOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.UpdateClassifierOptions;
import java.io.File;
import java.io.InputStream;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class VisualRecognition
extends WatsonService {
    private static final String SERVICE_NAME = "visual_recognition";
    private static final String URL = "https://gateway.watsonplatform.net/visual-recognition/api";
    private String versionDate;

    public VisualRecognition(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue(versionDate != null && !versionDate.isEmpty(), "version cannot be null.");
        this.versionDate = versionDate;
    }

    public VisualRecognition(String versionDate, String apiKey) {
        this(versionDate);
        this.setApiKey(apiKey);
    }

    @Override
    protected void setAuthentication(Request.Builder builder) {
        if (this.getUsername() != null && this.getPassword() != null || this.isTokenManagerSet()) {
            super.setAuthentication(builder);
        } else if (this.getApiKey() != null) {
            this.addApiKeyQueryParameter(builder, this.getApiKey());
        } else {
            throw new IllegalArgumentException("Credentials need to be specified. Use setApiKey(), setIamCredentials(), or setUsernameAndPassword().");
        }
    }

    private void addApiKeyQueryParameter(Request.Builder builder, String apiKey) {
        HttpUrl url = HttpUrl.parse(builder.build().url().toString());
        if (url.query() == null || url.query().isEmpty()) {
            builder.url(builder.build().url() + "?api_key=" + apiKey);
        } else {
            builder.url(builder.build().url() + "&api_key=" + apiKey);
        }
    }

    public VisualRecognition(String versionDate, IamOptions iamOptions) {
        this(versionDate);
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<ClassifiedImages> classify(ClassifyOptions classifyOptions) {
        Validator.notNull(classifyOptions, "classifyOptions cannot be null");
        Validator.isTrue(classifyOptions.imagesFile() != null || classifyOptions.url() != null || classifyOptions.threshold() != null || classifyOptions.owners() != null || classifyOptions.classifierIds() != null || classifyOptions.parameters() != null, "At least one of imagesFile, url, threshold, owners, classifierIds, or parameters must be supplied.");
        String[] pathSegments = new String[]{"v3/classify"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (classifyOptions.acceptLanguage() != null) {
            builder.header("Accept-Language", classifyOptions.acceptLanguage());
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (classifyOptions.imagesFile() != null) {
            RequestBody imagesFileBody = RequestUtils.inputStreamBody(classifyOptions.imagesFile(), classifyOptions.imagesFileContentType());
            multipartBuilder.addFormDataPart("images_file", classifyOptions.imagesFilename(), imagesFileBody);
        }
        if (classifyOptions.parameters() != null) {
            multipartBuilder.addFormDataPart("parameters", classifyOptions.parameters());
        }
        if (classifyOptions.url() != null) {
            multipartBuilder.addFormDataPart("url", classifyOptions.url());
        }
        if (classifyOptions.threshold() != null) {
            multipartBuilder.addFormDataPart("threshold", String.valueOf(classifyOptions.threshold()));
        }
        if (classifyOptions.owners() != null) {
            multipartBuilder.addFormDataPart("owners", RequestUtils.join(classifyOptions.owners(), ","));
        }
        if (classifyOptions.classifierIds() != null) {
            multipartBuilder.addFormDataPart("classifier_ids", RequestUtils.join(classifyOptions.classifierIds(), ","));
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ClassifiedImages.class));
    }

    public ServiceCall<ClassifiedImages> classify() {
        return this.classify(null);
    }

    public ServiceCall<DetectedFaces> detectFaces(DetectFacesOptions detectFacesOptions) {
        Validator.notNull(detectFacesOptions, "detectFacesOptions cannot be null");
        Validator.isTrue(detectFacesOptions.imagesFile() != null || detectFacesOptions.url() != null || detectFacesOptions.parameters() != null, "At least one of imagesFile, url, or parameters must be supplied.");
        String[] pathSegments = new String[]{"v3/detect_faces"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (detectFacesOptions.imagesFile() != null) {
            RequestBody imagesFileBody = RequestUtils.inputStreamBody(detectFacesOptions.imagesFile(), detectFacesOptions.imagesFileContentType());
            multipartBuilder.addFormDataPart("images_file", detectFacesOptions.imagesFilename(), imagesFileBody);
        }
        if (detectFacesOptions.parameters() != null) {
            multipartBuilder.addFormDataPart("parameters", detectFacesOptions.parameters());
        }
        if (detectFacesOptions.url() != null) {
            multipartBuilder.addFormDataPart("url", detectFacesOptions.url());
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DetectedFaces.class));
    }

    public ServiceCall<DetectedFaces> detectFaces() {
        return this.detectFaces(null);
    }

    public ServiceCall<Classifier> createClassifier(CreateClassifierOptions createClassifierOptions) {
        Validator.notNull(createClassifierOptions, "createClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("name", createClassifierOptions.name());
        for (String className : createClassifierOptions.classNames()) {
            String dataName = className + "_positive_examples";
            File positiveExamples = createClassifierOptions.positiveExamplesByClassName(className);
            RequestBody body = RequestUtils.fileBody(positiveExamples, "application/octet-stream");
            multipartBuilder.addFormDataPart(dataName, positiveExamples.getName(), body);
        }
        if (createClassifierOptions.negativeExamples() != null) {
            RequestBody negativeExamplesBody = RequestUtils.inputStreamBody(createClassifierOptions.negativeExamples(), "application/octet-stream");
            multipartBuilder.addFormDataPart("negative_examples", createClassifierOptions.negativeExamplesFilename(), negativeExamplesBody);
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<Void> deleteClassifier(DeleteClassifierOptions deleteClassifierOptions) {
        Validator.notNull(deleteClassifierOptions, "deleteClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{deleteClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Classifier> getClassifier(GetClassifierOptions getClassifierOptions) {
        Validator.notNull(getClassifierOptions, "getClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{getClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<Classifiers> listClassifiers(ListClassifiersOptions listClassifiersOptions) {
        String[] pathSegments = new String[]{"v3/classifiers"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        if (listClassifiersOptions != null && listClassifiersOptions.verbose() != null) {
            builder.query("verbose", String.valueOf(listClassifiersOptions.verbose()));
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifiers.class));
    }

    public ServiceCall<Classifiers> listClassifiers() {
        return this.listClassifiers(null);
    }

    public ServiceCall<Classifier> updateClassifier(UpdateClassifierOptions updateClassifierOptions) {
        Validator.notNull(updateClassifierOptions, "updateClassifierOptions cannot be null");
        Validator.isTrue(updateClassifierOptions.classNames().size() > 0 || updateClassifierOptions.negativeExamples() != null, "At least one of classnamePositiveExamples or negativeExamples must be supplied.");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{updateClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        for (String className : updateClassifierOptions.classNames()) {
            String dataName = className + "_positive_examples";
            File positiveExamples = updateClassifierOptions.positiveExamplesByClassName(className);
            RequestBody body = RequestUtils.fileBody(positiveExamples, "application/octet-stream");
            multipartBuilder.addFormDataPart(dataName, positiveExamples.getName(), body);
        }
        if (updateClassifierOptions.negativeExamples() != null) {
            RequestBody negativeExamplesBody = RequestUtils.inputStreamBody(updateClassifierOptions.negativeExamples(), "application/octet-stream");
            multipartBuilder.addFormDataPart("negative_examples", updateClassifierOptions.negativeExamplesFilename(), negativeExamplesBody);
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<InputStream> getCoreMlModel(GetCoreMlModelOptions getCoreMlModelOptions) {
        Validator.notNull(getCoreMlModelOptions, "getCoreMlModelOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers", "core_ml_model"};
        String[] pathParameters = new String[]{getCoreMlModelOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getInputStream());
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull(deleteUserDataOptions, "deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v3/user_data"};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        builder.query("customer_id", deleteUserDataOptions.customerId());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }
}

