/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.text_to_speech.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetPronunciationOptions
extends GenericModel {
    private String text;
    private String voice;
    private String format;
    private String customizationId;

    private GetPronunciationOptions(Builder builder) {
        Validator.notNull(builder.text, "text cannot be null");
        this.text = builder.text;
        this.voice = builder.voice;
        this.format = builder.format;
        this.customizationId = builder.customizationId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public String voice() {
        return this.voice;
    }

    public String format() {
        return this.format;
    }

    public String customizationId() {
        return this.customizationId;
    }

    public static class Builder {
        private String text;
        private String voice;
        private String format;
        private String customizationId;

        private Builder(GetPronunciationOptions getPronunciationOptions) {
            this.text = getPronunciationOptions.text;
            this.voice = getPronunciationOptions.voice;
            this.format = getPronunciationOptions.format;
            this.customizationId = getPronunciationOptions.customizationId;
        }

        public Builder() {
        }

        public Builder(String text) {
            this.text = text;
        }

        public GetPronunciationOptions build() {
            return new GetPronunciationOptions(this);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder voice(String voice) {
            this.voice = voice;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }
    }

    public static interface Format {
        public static final String IPA = "ipa";
        public static final String IBM = "ibm";
    }

    public static interface Voice {
        public static final String EN_US_ALLISONVOICE = "en-US_AllisonVoice";
        public static final String EN_US_LISAVOICE = "en-US_LisaVoice";
        public static final String EN_US_MICHAELVOICE = "en-US_MichaelVoice";
        public static final String EN_GB_KATEVOICE = "en-GB_KateVoice";
        public static final String ES_ES_ENRIQUEVOICE = "es-ES_EnriqueVoice";
        public static final String ES_ES_LAURAVOICE = "es-ES_LauraVoice";
        public static final String ES_LA_SOFIAVOICE = "es-LA_SofiaVoice";
        public static final String ES_US_SOFIAVOICE = "es-US_SofiaVoice";
        public static final String DE_DE_DIETERVOICE = "de-DE_DieterVoice";
        public static final String DE_DE_BIRGITVOICE = "de-DE_BirgitVoice";
        public static final String FR_FR_RENEEVOICE = "fr-FR_ReneeVoice";
        public static final String IT_IT_FRANCESCAVOICE = "it-IT_FrancescaVoice";
        public static final String JA_JP_EMIVOICE = "ja-JP_EmiVoice";
        public static final String PT_BR_ISABELAVOICE = "pt-BR_IsabelaVoice";
    }
}

