/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.websocket;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RecognizeOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechRecognitionResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.RecognizeCallback;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public final class SpeechToTextWebSocketListener
extends WebSocketListener {
    private static final String AUDIO_TO_WEB_SOCKET = "AudioToWebSocketThread";
    private static final Gson GSON = GsonSingleton.getGsonWithoutPrettyPrinting();
    private static final Logger LOG = Logger.getLogger(SpeechToTextWebSocketListener.class.getName());
    private static final String STATE = "state";
    private static final String MODEL = "model";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String ACTION = "action";
    private static final int ONE_KB = 1024;
    private static final String ERROR = "error";
    private static final String RESULTS = "results";
    private static final String SPEAKER_LABELS = "speaker_labels";
    private static final String CUSTOMIZATION_ID = "customization_id";
    private static final String ACOUSTIC_CUSTOMIZATION_ID = "acoustic_customization_id";
    private static final String CUSTOMIZATION_WEIGHT = "customization_weight";
    private static final String VERSION = "base_model_version";
    private static final String TIMEOUT_PREFIX = "No speech detected for";
    private static final long QUEUE_SIZE_LIMIT = 0x800000L;
    private static final long QUEUE_WAIT_MILLIS = 500L;
    private final InputStream stream;
    private final RecognizeOptions options;
    private final RecognizeCallback callback;
    private WebSocket socket;
    private boolean socketOpen = true;
    private Thread audioThread = null;
    private boolean isListening = false;
    private static final int CLOSE_NORMAL = 1000;

    public SpeechToTextWebSocketListener(RecognizeOptions options, RecognizeCallback callback) {
        this.stream = options.audio();
        this.options = options;
        this.callback = callback;
    }

    @Override
    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.socketOpen = false;
        this.callback.onDisconnected();
    }

    @Override
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.socketOpen = false;
        if (t instanceof Exception) {
            this.callback.onError((Exception)t);
        } else {
            this.callback.onError(new Exception(t));
        }
    }

    @Override
    public void onMessage(WebSocket webSocket, String message) {
        JsonObject json = new JsonParser().parse(message).getAsJsonObject();
        if (json.has(ERROR)) {
            String error = json.get(ERROR).getAsString();
            if (!error.startsWith(TIMEOUT_PREFIX)) {
                this.callback.onError(new RuntimeException(error));
            } else {
                this.callback.onInactivityTimeout(new RuntimeException(error));
            }
        } else if (json.has(RESULTS) || json.has(SPEAKER_LABELS)) {
            this.callback.onTranscription(GSON.fromJson(message, SpeechRecognitionResults.class));
        } else if (json.has(STATE)) {
            if (this.isListening) {
                this.callback.onTranscriptionComplete();
                this.socket.close(1000, "Transcription completed");
                return;
            }
            this.isListening = true;
            this.callback.onListening();
        }
    }

    @Override
    public void onOpen(final WebSocket socket, Response response) {
        this.callback.onConnected();
        this.socket = socket;
        if (!socket.send(this.buildStartMessage(this.options))) {
            this.callback.onError(new IOException("WebSocket unavailable"));
        } else {
            this.audioThread = new Thread(AUDIO_TO_WEB_SOCKET){

                @Override
                public void run() {
                    SpeechToTextWebSocketListener.this.sendInputStream(SpeechToTextWebSocketListener.this.stream);
                    if (SpeechToTextWebSocketListener.this.socketOpen && !socket.send(SpeechToTextWebSocketListener.this.buildStopMessage())) {
                        LOG.log(Level.SEVERE, "Stop message discarded because WebSocket is unavailable");
                    }
                }
            };
            this.audioThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInputStream(InputStream inputStream) {
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = inputStream.read(buffer)) > 0 && this.socketOpen) {
                while (this.socket.queueSize() > 0x800000L) {
                    Thread.sleep(500L);
                }
                if (read == 1024) {
                    this.socket.send(ByteString.of(buffer));
                    continue;
                }
                this.socket.send(ByteString.of(Arrays.copyOfRange(buffer, 0, read)));
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String buildStartMessage(RecognizeOptions options) {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        JsonObject startMessage = new JsonParser().parse(gson.toJson(options)).getAsJsonObject();
        startMessage.remove(MODEL);
        startMessage.remove(CUSTOMIZATION_ID);
        startMessage.remove(ACOUSTIC_CUSTOMIZATION_ID);
        startMessage.remove(CUSTOMIZATION_WEIGHT);
        startMessage.remove(VERSION);
        startMessage.addProperty(ACTION, START);
        return startMessage.toString();
    }

    private String buildStopMessage() {
        JsonObject stopMessage = new JsonObject();
        stopMessage.addProperty(ACTION, STOP);
        return stopMessage.toString();
    }
}

