/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class MediaTypeUtils {
    private static final Map<String, String> MEDIA_TYPES = new HashMap<String, String>();

    private MediaTypeUtils() {
    }

    public static String getMediaTypeFromFile(File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        return MEDIA_TYPES.get(fileName.substring(i).toLowerCase());
    }

    public static boolean isValidMediaType(String mediaType) {
        return mediaType != null && MEDIA_TYPES.values().contains(mediaType.toLowerCase());
    }

    static {
        MEDIA_TYPES.put(".wav", "audio/wav");
        MEDIA_TYPES.put(".ogg", "audio/ogg; codecs=opus");
        MEDIA_TYPES.put(".oga", "audio/ogg; codecs=opus");
        MEDIA_TYPES.put(".flac", "audio/flac");
        MEDIA_TYPES.put(".raw", "audio/l16");
        MEDIA_TYPES.put(".mp3", "audio/mp3");
        MEDIA_TYPES.put(".mpeg", "audio/mpeg");
        MEDIA_TYPES.put(".webm", "audio/webm");
    }
}

