/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class MultipartRecognition
extends GenericModel {
    @SerializedName(value="part_content_type")
    private String partContentType;
    @SerializedName(value="data_parts_count")
    private Long dataPartsCount;
    @SerializedName(value="sequence_id")
    private Long sequenceId;
    @SerializedName(value="inactivity_timeout")
    private Long inactivityTimeout;
    private List<String> keywords;
    @SerializedName(value="keywords_threshold")
    private Float keywordsThreshold;
    @SerializedName(value="max_alternatives")
    private Long maxAlternatives;
    @SerializedName(value="word_alternatives_threshold")
    private Float wordAlternativesThreshold;
    @SerializedName(value="word_confidence")
    private Boolean wordConfidence;
    private Boolean timestamps;
    @SerializedName(value="profanity_filter")
    private Boolean profanityFilter;
    @SerializedName(value="smart_formatting")
    private Boolean smartFormatting;
    @SerializedName(value="speaker_labels")
    private Boolean speakerLabels;

    private MultipartRecognition(Builder builder) {
        Validator.isTrue(builder.partContentType != null, "partContentType cannot be null");
        this.partContentType = builder.partContentType;
        this.dataPartsCount = builder.dataPartsCount;
        this.sequenceId = builder.sequenceId;
        this.inactivityTimeout = builder.inactivityTimeout;
        this.keywords = builder.keywords;
        this.keywordsThreshold = builder.keywordsThreshold;
        this.maxAlternatives = builder.maxAlternatives;
        this.wordAlternativesThreshold = builder.wordAlternativesThreshold;
        this.wordConfidence = builder.wordConfidence;
        this.timestamps = builder.timestamps;
        this.profanityFilter = builder.profanityFilter;
        this.smartFormatting = builder.smartFormatting;
        this.speakerLabels = builder.speakerLabels;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String partContentType() {
        return this.partContentType;
    }

    public Long dataPartsCount() {
        return this.dataPartsCount;
    }

    public Long sequenceId() {
        return this.sequenceId;
    }

    public Long inactivityTimeout() {
        return this.inactivityTimeout;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public Float keywordsThreshold() {
        return this.keywordsThreshold;
    }

    public Long maxAlternatives() {
        return this.maxAlternatives;
    }

    public Float wordAlternativesThreshold() {
        return this.wordAlternativesThreshold;
    }

    public Boolean wordConfidence() {
        return this.wordConfidence;
    }

    public Boolean timestamps() {
        return this.timestamps;
    }

    public Boolean profanityFilter() {
        return this.profanityFilter;
    }

    public Boolean smartFormatting() {
        return this.smartFormatting;
    }

    public Boolean speakerLabels() {
        return this.speakerLabels;
    }

    public static class Builder {
        private String partContentType;
        private Long dataPartsCount;
        private Long sequenceId;
        private Long inactivityTimeout;
        private List<String> keywords;
        private Float keywordsThreshold;
        private Long maxAlternatives;
        private Float wordAlternativesThreshold;
        private Boolean wordConfidence;
        private Boolean timestamps;
        private Boolean profanityFilter;
        private Boolean smartFormatting;
        private Boolean speakerLabels;

        private Builder(MultipartRecognition multipartRecognition) {
            this.partContentType = multipartRecognition.partContentType;
            this.dataPartsCount = multipartRecognition.dataPartsCount;
            this.sequenceId = multipartRecognition.sequenceId;
            this.inactivityTimeout = multipartRecognition.inactivityTimeout;
            this.keywords = multipartRecognition.keywords;
            this.keywordsThreshold = multipartRecognition.keywordsThreshold;
            this.maxAlternatives = multipartRecognition.maxAlternatives;
            this.wordAlternativesThreshold = multipartRecognition.wordAlternativesThreshold;
            this.wordConfidence = multipartRecognition.wordConfidence;
            this.timestamps = multipartRecognition.timestamps;
            this.profanityFilter = multipartRecognition.profanityFilter;
            this.smartFormatting = multipartRecognition.smartFormatting;
            this.speakerLabels = multipartRecognition.speakerLabels;
        }

        public Builder() {
        }

        public MultipartRecognition build() {
            return new MultipartRecognition(this);
        }

        public Builder addKeyword(String keyword) {
            Validator.notNull(this.keywords, "soundsLike cannot be null");
            if (this.keywords == null) {
                this.keywords = new ArrayList<String>();
            }
            this.keywords.add(keyword);
            return this;
        }

        public Builder partContentType(String partContentType) {
            this.partContentType = partContentType;
            return this;
        }

        public Builder dataPartsCount(Long dataPartsCount) {
            this.dataPartsCount = dataPartsCount;
            return this;
        }

        public Builder sequenceId(Long sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder inactivityTimeout(Long inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder keywordsThreshold(Float keywordsThreshold) {
            this.keywordsThreshold = keywordsThreshold;
            return this;
        }

        public Builder maxAlternatives(Long maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public Builder wordAlternativesThreshold(Float wordAlternativesThreshold) {
            this.wordAlternativesThreshold = wordAlternativesThreshold;
            return this;
        }

        public Builder wordConfidence(Boolean wordConfidence) {
            this.wordConfidence = wordConfidence;
            return this;
        }

        public Builder timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        public Builder smartFormatting(Boolean smartFormatting) {
            this.smartFormatting = smartFormatting;
            return this;
        }

        public Builder speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }
    }

    public static interface PartContentType {
        public static final String AUDIO_BASIC = "audio/basic";
        public static final String AUDIO_FLAC = "audio/flac";
        public static final String AUDIO_L16 = "audio/l16";
        public static final String AUDIO_MP3 = "audio/mp3";
        public static final String AUDIO_MPEG = "audio/mpeg";
        public static final String AUDIO_MULAW = "audio/mulaw";
        public static final String AUDIO_OGG = "audio/ogg";
        public static final String AUDIO_OGG_CODECS_OPUS = "audio/ogg;codecs=opus";
        public static final String AUDIO_OGG_CODECS_VORBIS = "audio/ogg;codecs=vorbis";
        public static final String AUDIO_WAV = "audio/wav";
        public static final String AUDIO_WEBM = "audio/webm";
        public static final String AUDIO_WEBM_CODECS_OPUS = "audio/webm;codecs=opus";
        public static final String AUDIO_WEBM_CODECS_VORBIS = "audio/webm;codecs=vorbis";
    }
}

