/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;

public class CreateSessionOptions
extends GenericModel {
    private String model;
    private String customizationId;
    private String acousticCustomizationId;
    private Double customizationWeight;
    private String version;

    private CreateSessionOptions(Builder builder) {
        this.model = builder.model;
        this.customizationId = builder.customizationId;
        this.acousticCustomizationId = builder.acousticCustomizationId;
        this.customizationWeight = builder.customizationWeight;
        this.version = builder.version;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String model() {
        return this.model;
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String acousticCustomizationId() {
        return this.acousticCustomizationId;
    }

    public Double customizationWeight() {
        return this.customizationWeight;
    }

    public String version() {
        return this.version;
    }

    public static class Builder {
        private String model;
        private String customizationId;
        private String acousticCustomizationId;
        private Double customizationWeight;
        private String version;

        private Builder(CreateSessionOptions createSessionOptions) {
            this.model = createSessionOptions.model;
            this.customizationId = createSessionOptions.customizationId;
            this.acousticCustomizationId = createSessionOptions.acousticCustomizationId;
            this.customizationWeight = createSessionOptions.customizationWeight;
            this.version = createSessionOptions.version;
        }

        public Builder() {
        }

        public CreateSessionOptions build() {
            return new CreateSessionOptions(this);
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder acousticCustomizationId(String acousticCustomizationId) {
            this.acousticCustomizationId = acousticCustomizationId;
            return this;
        }

        public Builder customizationWeight(Double customizationWeight) {
            this.customizationWeight = customizationWeight;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }
    }

    public static interface Model {
        public static final String AR_AR_BROADBANDMODEL = "ar-AR_BroadbandModel";
        public static final String EN_GB_BROADBANDMODEL = "en-GB_BroadbandModel";
        public static final String EN_GB_NARROWBANDMODEL = "en-GB_NarrowbandModel";
        public static final String EN_US_BROADBANDMODEL = "en-US_BroadbandModel";
        public static final String EN_US_NARROWBANDMODEL = "en-US_NarrowbandModel";
        public static final String ES_ES_BROADBANDMODEL = "es-ES_BroadbandModel";
        public static final String ES_ES_NARROWBANDMODEL = "es-ES_NarrowbandModel";
        public static final String FR_FR_BROADBANDMODEL = "fr-FR_BroadbandModel";
        public static final String JA_JP_BROADBANDMODEL = "ja-JP_BroadbandModel";
        public static final String JA_JP_NARROWBANDMODEL = "ja-JP_NarrowbandModel";
        public static final String PT_BR_BROADBANDMODEL = "pt-BR_BroadbandModel";
        public static final String PT_BR_NARROWBANDMODEL = "pt-BR_NarrowbandModel";
        public static final String ZH_CN_BROADBANDMODEL = "zh-CN_BroadbandModel";
        public static final String ZH_CN_NARROWBANDMODEL = "zh-CN_NarrowbandModel";
    }
}

