/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class CreateLanguageModelOptions
extends GenericModel {
    private String name;
    private String baseModelName;
    private String dialect;
    private String description;

    private CreateLanguageModelOptions(Builder builder) {
        Validator.notNull(builder.name, "name cannot be null");
        Validator.notNull(builder.baseModelName, "baseModelName cannot be null");
        this.name = builder.name;
        this.baseModelName = builder.baseModelName;
        this.dialect = builder.dialect;
        this.description = builder.description;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String baseModelName() {
        return this.baseModelName;
    }

    public String dialect() {
        return this.dialect;
    }

    public String description() {
        return this.description;
    }

    public static class Builder {
        private String name;
        private String baseModelName;
        private String dialect;
        private String description;

        private Builder(CreateLanguageModelOptions createLanguageModelOptions) {
            this.name = createLanguageModelOptions.name;
            this.baseModelName = createLanguageModelOptions.baseModelName;
            this.dialect = createLanguageModelOptions.dialect;
            this.description = createLanguageModelOptions.description;
        }

        public Builder() {
        }

        public Builder(String name, String baseModelName) {
            this.name = name;
            this.baseModelName = baseModelName;
        }

        public CreateLanguageModelOptions build() {
            return new CreateLanguageModelOptions(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        public Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }
    }

    public static interface BaseModelName {
        public static final String DE_DE_BROADBANDMODEL = "de-DE_BroadbandModel";
        public static final String EN_GB_BROADBANDMODEL = "en-GB_BroadbandModel";
        public static final String EN_GB_NARROWBANDMODEL = "en-GB_NarrowbandModel";
        public static final String EN_US_BROADBANDMODEL = "en-US_BroadbandModel";
        public static final String EN_US_NARROWBANDMODEL = "en-US_NarrowbandModel";
        public static final String ES_ES_BROADBANDMODEL = "es-ES_BroadbandModel";
        public static final String ES_ES_NARROWBANDMODEL = "es-ES_NarrowbandModel";
        public static final String FR_FR_BROADBANDMODEL = "fr-FR_BroadbandModel";
        public static final String JA_JP_BROADBANDMODEL = "ja-JP_BroadbandModel";
        public static final String JA_JP_NARROWBANDMODEL = "ja-JP_NarrowbandModel";
        public static final String KO_KR_BROADBANDMODEL = "ko-KR_BroadbandModel";
        public static final String KO_KR_NARROWBANDMODEL = "ko-KR_NarrowbandModel";
        public static final String PT_BR_BROADBANDMODEL = "pt-BR_BroadbandModel";
        public static final String PT_BR_NARROWBANDMODEL = "pt-BR_NarrowbandModel";
    }
}

