/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CreateJobOptions
extends GenericModel {
    private InputStream audio;
    private String contentType;
    private String model;
    private String callbackUrl;
    private String events;
    private String userToken;
    private Long resultsTtl;
    private String customizationId;
    private String acousticCustomizationId;
    private String baseModelVersion;
    private Double customizationWeight;
    private Long inactivityTimeout;
    private List<String> keywords;
    private Float keywordsThreshold;
    private Long maxAlternatives;
    private Float wordAlternativesThreshold;
    private Boolean wordConfidence;
    private Boolean timestamps;
    private Boolean profanityFilter;
    private Boolean smartFormatting;
    private Boolean speakerLabels;

    private CreateJobOptions(Builder builder) {
        Validator.isTrue(builder.contentType != null, "contentType cannot be null");
        this.audio = builder.audio;
        this.contentType = builder.contentType;
        this.model = builder.model;
        this.callbackUrl = builder.callbackUrl;
        this.events = builder.events;
        this.userToken = builder.userToken;
        this.resultsTtl = builder.resultsTtl;
        this.customizationId = builder.customizationId;
        this.acousticCustomizationId = builder.acousticCustomizationId;
        this.baseModelVersion = builder.baseModelVersion;
        this.customizationWeight = builder.customizationWeight;
        this.inactivityTimeout = builder.inactivityTimeout;
        this.keywords = builder.keywords;
        this.keywordsThreshold = builder.keywordsThreshold;
        this.maxAlternatives = builder.maxAlternatives;
        this.wordAlternativesThreshold = builder.wordAlternativesThreshold;
        this.wordConfidence = builder.wordConfidence;
        this.timestamps = builder.timestamps;
        this.profanityFilter = builder.profanityFilter;
        this.smartFormatting = builder.smartFormatting;
        this.speakerLabels = builder.speakerLabels;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream audio() {
        return this.audio;
    }

    public String contentType() {
        return this.contentType;
    }

    public String model() {
        return this.model;
    }

    public String callbackUrl() {
        return this.callbackUrl;
    }

    public String events() {
        return this.events;
    }

    public String userToken() {
        return this.userToken;
    }

    public Long resultsTtl() {
        return this.resultsTtl;
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String acousticCustomizationId() {
        return this.acousticCustomizationId;
    }

    public String baseModelVersion() {
        return this.baseModelVersion;
    }

    public Double customizationWeight() {
        return this.customizationWeight;
    }

    public Long inactivityTimeout() {
        return this.inactivityTimeout;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public Float keywordsThreshold() {
        return this.keywordsThreshold;
    }

    public Long maxAlternatives() {
        return this.maxAlternatives;
    }

    public Float wordAlternativesThreshold() {
        return this.wordAlternativesThreshold;
    }

    public Boolean wordConfidence() {
        return this.wordConfidence;
    }

    public Boolean timestamps() {
        return this.timestamps;
    }

    public Boolean profanityFilter() {
        return this.profanityFilter;
    }

    public Boolean smartFormatting() {
        return this.smartFormatting;
    }

    public Boolean speakerLabels() {
        return this.speakerLabels;
    }

    public static class Builder {
        private InputStream audio;
        private String contentType;
        private String model;
        private String callbackUrl;
        private String events;
        private String userToken;
        private Long resultsTtl;
        private String customizationId;
        private String acousticCustomizationId;
        private String baseModelVersion;
        private Double customizationWeight;
        private Long inactivityTimeout;
        private List<String> keywords;
        private Float keywordsThreshold;
        private Long maxAlternatives;
        private Float wordAlternativesThreshold;
        private Boolean wordConfidence;
        private Boolean timestamps;
        private Boolean profanityFilter;
        private Boolean smartFormatting;
        private Boolean speakerLabels;

        private Builder(CreateJobOptions createJobOptions) {
            this.audio = createJobOptions.audio;
            this.contentType = createJobOptions.contentType;
            this.model = createJobOptions.model;
            this.callbackUrl = createJobOptions.callbackUrl;
            this.events = createJobOptions.events;
            this.userToken = createJobOptions.userToken;
            this.resultsTtl = createJobOptions.resultsTtl;
            this.customizationId = createJobOptions.customizationId;
            this.acousticCustomizationId = createJobOptions.acousticCustomizationId;
            this.baseModelVersion = createJobOptions.baseModelVersion;
            this.customizationWeight = createJobOptions.customizationWeight;
            this.inactivityTimeout = createJobOptions.inactivityTimeout;
            this.keywords = createJobOptions.keywords;
            this.keywordsThreshold = createJobOptions.keywordsThreshold;
            this.maxAlternatives = createJobOptions.maxAlternatives;
            this.wordAlternativesThreshold = createJobOptions.wordAlternativesThreshold;
            this.wordConfidence = createJobOptions.wordConfidence;
            this.timestamps = createJobOptions.timestamps;
            this.profanityFilter = createJobOptions.profanityFilter;
            this.smartFormatting = createJobOptions.smartFormatting;
            this.speakerLabels = createJobOptions.speakerLabels;
        }

        public Builder() {
        }

        public CreateJobOptions build() {
            return new CreateJobOptions(this);
        }

        public Builder addKeyword(String keyword) {
            Validator.notNull(keyword, "keyword cannot be null");
            if (this.keywords == null) {
                this.keywords = new ArrayList<String>();
            }
            this.keywords.add(keyword);
            return this;
        }

        public Builder audio(InputStream audio) {
            this.audio = audio;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder events(String events) {
            this.events = events;
            return this;
        }

        public Builder userToken(String userToken) {
            this.userToken = userToken;
            return this;
        }

        public Builder resultsTtl(long resultsTtl) {
            this.resultsTtl = resultsTtl;
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder acousticCustomizationId(String acousticCustomizationId) {
            this.acousticCustomizationId = acousticCustomizationId;
            return this;
        }

        public Builder baseModelVersion(String baseModelVersion) {
            this.baseModelVersion = baseModelVersion;
            return this;
        }

        public Builder customizationWeight(Double customizationWeight) {
            this.customizationWeight = customizationWeight;
            return this;
        }

        public Builder inactivityTimeout(long inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder keywordsThreshold(Float keywordsThreshold) {
            this.keywordsThreshold = keywordsThreshold;
            return this;
        }

        public Builder maxAlternatives(long maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public Builder wordAlternativesThreshold(Float wordAlternativesThreshold) {
            this.wordAlternativesThreshold = wordAlternativesThreshold;
            return this;
        }

        public Builder wordConfidence(Boolean wordConfidence) {
            this.wordConfidence = wordConfidence;
            return this;
        }

        public Builder timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        public Builder smartFormatting(Boolean smartFormatting) {
            this.smartFormatting = smartFormatting;
            return this;
        }

        public Builder speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        public Builder audio(File audio) throws FileNotFoundException {
            this.audio = new FileInputStream(audio);
            return this;
        }
    }

    public static interface Events {
        public static final String RECOGNITIONS_STARTED = "recognitions.started";
        public static final String RECOGNITIONS_COMPLETED = "recognitions.completed";
        public static final String RECOGNITIONS_COMPLETED_WITH_RESULTS = "recognitions.completed_with_results";
        public static final String RECOGNITIONS_FAILED = "recognitions.failed";
    }

    public static interface Model {
        public static final String AR_AR_BROADBANDMODEL = "ar-AR_BroadbandModel";
        public static final String DE_DE_BROADBANDMODEL = "de-DE_BroadbandModel";
        public static final String EN_GB_BROADBANDMODEL = "en-GB_BroadbandModel";
        public static final String EN_GB_NARROWBANDMODEL = "en-GB_NarrowbandModel";
        public static final String EN_US_BROADBANDMODEL = "en-US_BroadbandModel";
        public static final String EN_US_NARROWBANDMODEL = "en-US_NarrowbandModel";
        public static final String ES_ES_BROADBANDMODEL = "es-ES_BroadbandModel";
        public static final String ES_ES_NARROWBANDMODEL = "es-ES_NarrowbandModel";
        public static final String FR_FR_BROADBANDMODEL = "fr-FR_BroadbandModel";
        public static final String JA_JP_BROADBANDMODEL = "ja-JP_BroadbandModel";
        public static final String JA_JP_NARROWBANDMODEL = "ja-JP_NarrowbandModel";
        public static final String KO_KR_BROADBANDMODEL = "ko-KR_BroadbandModel";
        public static final String KO_KR_NARROWBANDMODEL = "ko-KR_NarrowbandModel";
        public static final String PT_BR_BROADBANDMODEL = "pt-BR_BroadbandModel";
        public static final String PT_BR_NARROWBANDMODEL = "pt-BR_NarrowbandModel";
        public static final String ZH_CN_BROADBANDMODEL = "zh-CN_BroadbandModel";
        public static final String ZH_CN_NARROWBANDMODEL = "zh-CN_NarrowbandModel";
    }

    public static interface ContentType {
        public static final String AUDIO_BASIC = "audio/basic";
        public static final String AUDIO_FLAC = "audio/flac";
        public static final String AUDIO_L16 = "audio/l16";
        public static final String AUDIO_MP3 = "audio/mp3";
        public static final String AUDIO_MPEG = "audio/mpeg";
        public static final String AUDIO_MULAW = "audio/mulaw";
        public static final String AUDIO_OGG = "audio/ogg";
        public static final String AUDIO_OGG_CODECS_OPUS = "audio/ogg;codecs=opus";
        public static final String AUDIO_OGG_CODECS_VORBIS = "audio/ogg;codecs=vorbis";
        public static final String AUDIO_WAV = "audio/wav";
        public static final String AUDIO_WEBM = "audio/webm";
        public static final String AUDIO_WEBM_CODECS_OPUS = "audio/webm;codecs=opus";
        public static final String AUDIO_WEBM_CODECS_VORBIS = "audio/webm;codecs=vorbis";
    }
}

