/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.HttpClientSingleton;
import com.ibm.watson.developer_cloud.http.HttpConfigOptions;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.Response;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.http.ServiceCallback;
import com.ibm.watson.developer_cloud.http.ServiceCallbackWithDetails;
import com.ibm.watson.developer_cloud.service.exception.BadRequestException;
import com.ibm.watson.developer_cloud.service.exception.ConflictException;
import com.ibm.watson.developer_cloud.service.exception.ForbiddenException;
import com.ibm.watson.developer_cloud.service.exception.InternalServerErrorException;
import com.ibm.watson.developer_cloud.service.exception.NotFoundException;
import com.ibm.watson.developer_cloud.service.exception.RequestTooLargeException;
import com.ibm.watson.developer_cloud.service.exception.ServiceResponseException;
import com.ibm.watson.developer_cloud.service.exception.ServiceUnavailableException;
import com.ibm.watson.developer_cloud.service.exception.TooManyRequestsException;
import com.ibm.watson.developer_cloud.service.exception.UnauthorizedException;
import com.ibm.watson.developer_cloud.service.exception.UnsupportedException;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.service.security.IamTokenManager;
import com.ibm.watson.developer_cloud.util.CredentialUtils;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.ResponseUtils;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jersey.repackaged.jsr166e.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public abstract class WatsonService {
    private static final String URL = "url";
    private static final String PATH_AUTHORIZATION_V1_TOKEN = "/v1/token";
    private static final String AUTHORIZATION = "authorization";
    private static final String MESSAGE_ERROR_3 = "message";
    private static final String MESSAGE_ERROR_2 = "error_message";
    private static final String BASIC = "Basic ";
    private static final String BEARER = "Bearer ";
    private static final String APIKEY_AS_USERNAME = "apikey";
    private static final String ICP_PREFIX = "icp-";
    private static final Logger LOG = Logger.getLogger(WatsonService.class.getName());
    private static final String AUTH_HEADER_DEPRECATION_MESSAGE = "Authenticating with the X-Watson-Authorization-Tokenheader is deprecated. The token continues to work with Cloud Foundry services, but is not supported for services that use Identity and Access Management (IAM) authentication. For details see the IAM authentication section in the README.";
    private String apiKey;
    private String username;
    private String password;
    private String endPoint;
    private String defaultEndPoint;
    private final String name;
    private IamTokenManager tokenManager;
    private OkHttpClient client;
    protected Headers defaultHeaders = null;
    protected boolean skipAuthentication = false;
    protected static final String MESSAGE_CODE = "code";
    protected static final String MESSAGE_ERROR = "error";
    protected static final String VERSION = "version";
    protected static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/((json)|(merge\\-patch\\+json))(;.*)?");
    protected static final Pattern JSON_PATCH_MIME_PATTERN = Pattern.compile("(?i)application\\/json\\-patch\\+json(;.*)?");

    public WatsonService(String name) {
        this.name = name;
        String iamApiKey = CredentialUtils.getIAMKey(name);
        String iamUrl = CredentialUtils.getIAMUrl(name);
        if (iamApiKey != null) {
            IamOptions iamOptions = new IamOptions.Builder().apiKey(iamApiKey).url(iamUrl).build();
            this.tokenManager = new IamTokenManager(iamOptions);
        }
        this.apiKey = CredentialUtils.getAPIKey(name);
        String url = CredentialUtils.getAPIUrl(name);
        if (url != null && !url.isEmpty()) {
            this.setEndPoint(url);
        }
        this.client = this.configureHttpClient();
    }

    public static boolean isJsonMimeType(String mimeType) {
        return mimeType != null && JSON_MIME_PATTERN.matcher(mimeType).matches();
    }

    public static boolean isJsonPatchMimeType(String mimeType) {
        return mimeType != null && JSON_PATCH_MIME_PATTERN.matcher(mimeType).matches();
    }

    protected OkHttpClient configureHttpClient() {
        return HttpClientSingleton.getInstance().createHttpClient();
    }

    public void configureClient(HttpConfigOptions options) {
        HttpClientSingleton.getInstance().configureClient(options);
    }

    private Call createCall(Request request) {
        Request.Builder builder = request.newBuilder();
        this.setDefaultHeaders(builder);
        this.setAuthentication(builder);
        Request newRequest = builder.build();
        return this.client.newCall(newRequest);
    }

    protected void setDefaultHeaders(Request.Builder builder) {
        String userAgent = RequestUtils.getUserAgent();
        if (this.defaultHeaders != null) {
            for (String key : this.defaultHeaders.names()) {
                builder.header(key, this.defaultHeaders.get(key));
            }
            if (this.defaultHeaders.get("User-Agent") != null) {
                userAgent = userAgent + " " + this.defaultHeaders.get("User-Agent");
            }
        }
        builder.header("User-Agent", userAgent);
    }

    protected final <T> ServiceCall<T> createServiceCall(Request request, ResponseConverter<T> converter) {
        Call call = this.createCall(request);
        return new WatsonServiceCall<T>(call, converter);
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public ServiceCall<String> getToken() {
        HttpUrl url = HttpUrl.parse(this.getEndPoint()).newBuilder().setPathSegment(0, AUTHORIZATION).addPathSegment(PATH_AUTHORIZATION_V1_TOKEN).build();
        Request request = RequestBuilder.get(url).header("Accept", "text/plain").query(URL, this.getEndPoint()).build();
        return this.createServiceCall(request, ResponseConverterUtils.getString());
    }

    protected boolean isTokenManagerSet() {
        return this.tokenManager != null;
    }

    private String getErrorMessage(okhttp3.Response response) {
        String error = ResponseUtils.getString(response);
        try {
            JsonObject jsonObject = ResponseUtils.getJsonObject(error);
            if (jsonObject.has(MESSAGE_ERROR)) {
                error = jsonObject.get(MESSAGE_ERROR).getAsString();
            } else if (jsonObject.has(MESSAGE_ERROR_2)) {
                error = jsonObject.get(MESSAGE_ERROR_2).getAsString();
            } else if (jsonObject.has(MESSAGE_ERROR_3)) {
                error = jsonObject.get(MESSAGE_ERROR_3).getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return error;
    }

    public String getName() {
        return this.name;
    }

    public void setApiKey(String apiKey) {
        if (this.endPoint.equals(this.defaultEndPoint)) {
            this.endPoint = "https://gateway-a.watsonplatform.net/visual-recognition/api";
        }
        this.apiKey = apiKey;
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.tokenManager != null) {
            String accessToken = this.tokenManager.getToken();
            builder.addHeader("Authorization", BEARER + accessToken);
        } else {
            if (this.getApiKey() == null) {
                if (this.skipAuthentication) {
                    Headers currentHeaders = builder.build().headers();
                    if (currentHeaders.get("X-Watson-Authorization-Token") != null) {
                        LOG.warning(AUTH_HEADER_DEPRECATION_MESSAGE);
                    }
                    return;
                }
                throw new IllegalArgumentException("apiKey or username and password were not specified");
            }
            builder.addHeader("Authorization", this.apiKey.startsWith(BASIC) ? this.apiKey : BASIC + this.apiKey);
        }
    }

    public void setEndPoint(String endPoint) {
        if (endPoint != null && !endPoint.isEmpty()) {
            String newEndPoint;
            String string = newEndPoint = endPoint.endsWith("/") ? endPoint.substring(0, endPoint.length() - 1) : endPoint;
            if (this.endPoint == null) {
                this.defaultEndPoint = newEndPoint;
            }
            this.endPoint = newEndPoint;
        }
    }

    public void setUsernameAndPassword(String username, String password) {
        if (username.equals(APIKEY_AS_USERNAME) && !password.startsWith(ICP_PREFIX)) {
            IamOptions iamOptions = new IamOptions.Builder().apiKey(password).build();
            this.setIamCredentials(iamOptions);
        } else {
            this.username = username;
            this.password = password;
            this.apiKey = Credentials.basic(username, password);
        }
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders = headers == null ? null : Headers.of(headers);
    }

    public void setIamCredentials(IamOptions iamOptions) {
        this.tokenManager = new IamTokenManager(iamOptions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.name).append(" [");
        if (this.endPoint != null) {
            builder.append("endPoint=").append(this.endPoint);
        }
        return builder.append(']').toString();
    }

    protected <T> T processServiceCall(ResponseConverter<T> converter, okhttp3.Response response) {
        if (response.isSuccessful()) {
            return converter.convert(response);
        }
        String error = this.getErrorMessage(response);
        LOG.log(Level.SEVERE, response.request().method() + " " + response.request().url().toString() + ", status: " + response.code() + ", error: " + error);
        switch (response.code()) {
            case 400: {
                throw new BadRequestException(error != null ? error : "Bad Request", response);
            }
            case 401: {
                throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials. Tip: Did you set the Endpoint?", response);
            }
            case 403: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request", response);
            }
            case 404: {
                throw new NotFoundException(error != null ? error : "Not found", response);
            }
            case 406: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request", response);
            }
            case 409: {
                throw new ConflictException(error != null ? error : "", response);
            }
            case 413: {
                throw new RequestTooLargeException(error != null ? error : "Request too large: The request entity is larger than the server is able to process", response);
            }
            case 415: {
                throw new UnsupportedException(error != null ? error : "Unsupported Media Type", response);
            }
            case 429: {
                throw new TooManyRequestsException(error != null ? error : "Too many requests", response);
            }
            case 500: {
                throw new InternalServerErrorException(error != null ? error : "Internal Server Error", response);
            }
            case 503: {
                throw new ServiceUnavailableException(error != null ? error : "Service Unavailable", response);
            }
        }
        throw new ServiceResponseException(response.code(), error, response);
    }

    public void setSkipAuthentication(boolean skipAuthentication) {
        this.skipAuthentication = skipAuthentication;
    }

    class WatsonServiceCall<T>
    implements ServiceCall<T> {
        private Call call;
        private ResponseConverter<T> converter;

        WatsonServiceCall(Call call, ResponseConverter<T> converter) {
            this.call = call;
            this.converter = converter;
        }

        @Override
        public ServiceCall<T> addHeader(String name, String value) {
            Request.Builder builder = this.call.request().newBuilder();
            builder.header(name, value);
            this.call = WatsonService.this.client.newCall(builder.build());
            return this;
        }

        @Override
        public T execute() {
            try {
                okhttp3.Response response = this.call.execute();
                return WatsonService.this.processServiceCall(this.converter, response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Response<T> executeWithDetails() throws RuntimeException {
            try {
                okhttp3.Response httpResponse = this.call.execute();
                T responseModel = WatsonService.this.processServiceCall(this.converter, httpResponse);
                return new Response<T>(responseModel, httpResponse);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void enqueue(final ServiceCallback<? super T> callback) {
            this.call.enqueue(new Callback(){

                @Override
                public void onFailure(Call call, IOException e) {
                    callback.onFailure(e);
                }

                @Override
                public void onResponse(Call call, okhttp3.Response response) {
                    try {
                        callback.onResponse(WatsonService.this.processServiceCall(WatsonServiceCall.this.converter, response));
                    }
                    catch (Exception e) {
                        callback.onFailure(e);
                    }
                }
            });
        }

        @Override
        public void enqueueWithDetails(final ServiceCallbackWithDetails<T> callback) {
            this.call.enqueue(new Callback(){

                @Override
                public void onFailure(Call call, IOException e) {
                    callback.onFailure(e);
                }

                @Override
                public void onResponse(Call call, okhttp3.Response response) {
                    try {
                        Object responseModel = WatsonService.this.processServiceCall(WatsonServiceCall.this.converter, response);
                        callback.onResponse(new Response(responseModel, response));
                    }
                    catch (Exception e) {
                        callback.onFailure(e);
                    }
                }
            });
        }

        @Override
        public CompletableFuture<T> rx() {
            final CompletableFuture completableFuture = new CompletableFuture();
            this.call.enqueue(new Callback(){

                @Override
                public void onFailure(Call call, IOException e) {
                    completableFuture.completeExceptionally(e);
                }

                @Override
                public void onResponse(Call call, okhttp3.Response response) {
                    try {
                        completableFuture.complete(WatsonService.this.processServiceCall(WatsonServiceCall.this.converter, response));
                    }
                    catch (Exception e) {
                        completableFuture.completeExceptionally(e);
                    }
                }
            });
            return completableFuture;
        }

        @Override
        public CompletableFuture<Response<T>> rxWithDetails() {
            final CompletableFuture<Response<T>> completableFuture = new CompletableFuture<Response<T>>();
            this.call.enqueue(new Callback(){

                @Override
                public void onFailure(Call call, IOException e) {
                    completableFuture.completeExceptionally(e);
                }

                @Override
                public void onResponse(Call call, okhttp3.Response response) {
                    try {
                        Object responseModel = WatsonService.this.processServiceCall(WatsonServiceCall.this.converter, response);
                        completableFuture.complete(new Response(responseModel, response));
                    }
                    catch (Exception e) {
                        completableFuture.completeExceptionally(e);
                    }
                }
            });
            return completableFuture;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.call.isExecuted()) {
                Request r = this.call.request();
                LOG.warning(r.method() + " request to " + r.url() + " has not been sent. Did you forget to call execute()?");
            }
        }
    }
}

