/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class ContentItem
extends GenericModel {
    private String content;
    private String id;
    private Long created;
    private Long updated;
    private String contenttype;
    private String language;
    private String parentid;
    private Boolean reply;
    private Boolean forward;

    private ContentItem(Builder builder) {
        Validator.notNull(builder.content, "content cannot be null");
        this.content = builder.content;
        this.id = builder.id;
        this.created = builder.created;
        this.updated = builder.updated;
        this.contenttype = builder.contenttype;
        this.language = builder.language;
        this.parentid = builder.parentid;
        this.reply = builder.reply;
        this.forward = builder.forward;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String content() {
        return this.content;
    }

    public String id() {
        return this.id;
    }

    public Long created() {
        return this.created;
    }

    public Long updated() {
        return this.updated;
    }

    public String contenttype() {
        return this.contenttype;
    }

    public String language() {
        return this.language;
    }

    public String parentid() {
        return this.parentid;
    }

    public Boolean reply() {
        return this.reply;
    }

    public Boolean forward() {
        return this.forward;
    }

    public static class Builder {
        private String content;
        private String id;
        private Long created;
        private Long updated;
        private String contenttype;
        private String language;
        private String parentid;
        private Boolean reply;
        private Boolean forward;

        private Builder(ContentItem contentItem) {
            this.content = contentItem.content;
            this.id = contentItem.id;
            this.created = contentItem.created;
            this.updated = contentItem.updated;
            this.contenttype = contentItem.contenttype;
            this.language = contentItem.language;
            this.parentid = contentItem.parentid;
            this.reply = contentItem.reply;
            this.forward = contentItem.forward;
        }

        public Builder() {
        }

        public Builder(String content) {
            this.content = content;
        }

        public ContentItem build() {
            return new ContentItem(this);
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder created(long created) {
            this.created = created;
            return this;
        }

        public Builder updated(long updated) {
            this.updated = updated;
            return this;
        }

        public Builder contenttype(String contenttype) {
            this.contenttype = contenttype;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder parentid(String parentid) {
            this.parentid = parentid;
            return this;
        }

        public Builder reply(Boolean reply) {
            this.reply = reply;
            return this;
        }

        public Builder forward(Boolean forward) {
            this.forward = forward;
            return this;
        }
    }

    public static interface Language {
        public static final String AR = "ar";
        public static final String EN = "en";
        public static final String ES = "es";
        public static final String JA = "ja";
        public static final String KO = "ko";
    }

    public static interface Contenttype {
        public static final String TEXT_PLAIN = "text/plain";
        public static final String TEXT_HTML = "text/html";
    }
}

