/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v3;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.personality_insights.v3.model.Profile;
import com.ibm.watson.developer_cloud.personality_insights.v3.model.ProfileOptions;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.InputStream;

public class PersonalityInsights
extends WatsonService {
    private static final String SERVICE_NAME = "personality_insights";
    private static final String URL = "https://gateway.watsonplatform.net/personality-insights/api";
    private String versionDate;

    public PersonalityInsights(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue(versionDate != null && !versionDate.isEmpty(), "version cannot be null.");
        this.versionDate = versionDate;
    }

    public PersonalityInsights(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public PersonalityInsights(String versionDate, IamOptions iamOptions) {
        this(versionDate);
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<Profile> profile(ProfileOptions profileOptions) {
        Validator.notNull(profileOptions, "profileOptions cannot be null");
        String[] pathSegments = new String[]{"v3/profile"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        builder.header("Content-Type", profileOptions.contentType());
        if (profileOptions.contentLanguage() != null) {
            builder.header("Content-Language", profileOptions.contentLanguage());
        }
        if (profileOptions.acceptLanguage() != null) {
            builder.header("Accept-Language", profileOptions.acceptLanguage());
        }
        if (profileOptions.rawScores() != null) {
            builder.query("raw_scores", String.valueOf(profileOptions.rawScores()));
        }
        if (profileOptions.consumptionPreferences() != null) {
            builder.query("consumption_preferences", String.valueOf(profileOptions.consumptionPreferences()));
        }
        builder.bodyContent(profileOptions.contentType(), (Object)profileOptions.content(), null, profileOptions.body());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Profile.class));
    }

    public ServiceCall<InputStream> profileAsCsv(ProfileOptions profileOptions, boolean includeHeaders) {
        Validator.notNull(profileOptions, "profileOptions cannot be null");
        String[] pathSegments = new String[]{"v3/profile"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("version", this.versionDate);
        builder.header("Content-Type", profileOptions.contentType());
        if (profileOptions.contentLanguage() != null) {
            builder.header("Content-Language", profileOptions.contentLanguage());
        }
        if (profileOptions.acceptLanguage() != null) {
            builder.header("Accept-Language", profileOptions.acceptLanguage());
        }
        if (profileOptions.rawScores() != null) {
            builder.query("raw_scores", String.valueOf(profileOptions.rawScores()));
        }
        if (profileOptions.consumptionPreferences() != null) {
            builder.query("consumption_preferences", String.valueOf(profileOptions.consumptionPreferences()));
        }
        builder.header("Accept", "text/csv");
        builder.query("csv_headers", includeHeaders);
        builder.bodyContent(profileOptions.contentType(), (Object)profileOptions.content(), null, profileOptions.body());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getInputStream());
    }
}

