/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_understanding.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class SentimentOptions
extends GenericModel {
    private Boolean document;
    private List<String> targets;

    private SentimentOptions(Builder builder) {
        this.document = builder.document;
        this.targets = builder.targets;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Boolean document() {
        return this.document;
    }

    public List<String> targets() {
        return this.targets;
    }

    public static class Builder {
        private Boolean document;
        private List<String> targets;

        private Builder(SentimentOptions sentimentOptions) {
            this.document = sentimentOptions.document;
            this.targets = sentimentOptions.targets;
        }

        public Builder() {
        }

        public SentimentOptions build() {
            return new SentimentOptions(this);
        }

        public Builder addTargets(String targets) {
            Validator.notNull(targets, "targets cannot be null");
            if (this.targets == null) {
                this.targets = new ArrayList<String>();
            }
            this.targets.add(targets);
            return this;
        }

        public Builder document(Boolean document) {
            this.document = document;
            return this;
        }

        public Builder targets(List<String> targets) {
            this.targets = targets;
            return this;
        }
    }
}

