/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.language_translator.v2;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.language_translator.v2.model.CreateModelOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.DeleteModelOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.GetModelOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.IdentifiableLanguages;
import com.ibm.watson.developer_cloud.language_translator.v2.model.IdentifiedLanguages;
import com.ibm.watson.developer_cloud.language_translator.v2.model.IdentifyOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.ListIdentifiableLanguagesOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.ListModelsOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.TranslateOptions;
import com.ibm.watson.developer_cloud.language_translator.v2.model.TranslationModel;
import com.ibm.watson.developer_cloud.language_translator.v2.model.TranslationModels;
import com.ibm.watson.developer_cloud.language_translator.v2.model.TranslationResult;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

@Deprecated
public class LanguageTranslator
extends WatsonService {
    private static final String SERVICE_NAME = "language_translator";
    private static final String URL = "https://gateway.watsonplatform.net/language-translator/api";

    public LanguageTranslator() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public LanguageTranslator(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public LanguageTranslator(IamOptions iamOptions) {
        this();
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<TranslationResult> translate(TranslateOptions translateOptions) {
        Validator.notNull(translateOptions, "translateOptions cannot be null");
        String[] pathSegments = new String[]{"v2/translate"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        JsonObject contentJson = new JsonObject();
        contentJson.add("text", GsonSingleton.getGson().toJsonTree(translateOptions.text()));
        if (translateOptions.modelId() != null) {
            contentJson.addProperty("model_id", translateOptions.modelId());
        }
        if (translateOptions.source() != null) {
            contentJson.addProperty("source", translateOptions.source());
        }
        if (translateOptions.target() != null) {
            contentJson.addProperty("target", translateOptions.target());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TranslationResult.class));
    }

    public ServiceCall<IdentifiedLanguages> identify(IdentifyOptions identifyOptions) {
        Validator.notNull(identifyOptions, "identifyOptions cannot be null");
        String[] pathSegments = new String[]{"v2/identify"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.bodyContent(identifyOptions.text(), "text/plain");
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(IdentifiedLanguages.class));
    }

    public ServiceCall<IdentifiableLanguages> listIdentifiableLanguages(ListIdentifiableLanguagesOptions listIdentifiableLanguagesOptions) {
        String[] pathSegments = new String[]{"v2/identifiable_languages"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (listIdentifiableLanguagesOptions != null) {
            // empty if block
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(IdentifiableLanguages.class));
    }

    public ServiceCall<IdentifiableLanguages> listIdentifiableLanguages() {
        return this.listIdentifiableLanguages(null);
    }

    public ServiceCall<TranslationModel> createModel(CreateModelOptions createModelOptions) {
        Validator.notNull(createModelOptions, "createModelOptions cannot be null");
        Validator.isTrue(createModelOptions.forcedGlossary() != null || createModelOptions.parallelCorpus() != null || createModelOptions.monolingualCorpus() != null, "At least one of forcedGlossary, parallelCorpus, or monolingualCorpus must be supplied.");
        String[] pathSegments = new String[]{"v2/models"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("base_model_id", createModelOptions.baseModelId());
        if (createModelOptions.name() != null) {
            builder.query("name", createModelOptions.name());
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (createModelOptions.forcedGlossary() != null) {
            RequestBody forcedGlossaryBody = RequestUtils.inputStreamBody(createModelOptions.forcedGlossary(), "application/octet-stream");
            multipartBuilder.addFormDataPart("forced_glossary", createModelOptions.forcedGlossaryFilename(), forcedGlossaryBody);
        }
        if (createModelOptions.parallelCorpus() != null) {
            RequestBody parallelCorpusBody = RequestUtils.inputStreamBody(createModelOptions.parallelCorpus(), "application/octet-stream");
            multipartBuilder.addFormDataPart("parallel_corpus", createModelOptions.parallelCorpusFilename(), parallelCorpusBody);
        }
        if (createModelOptions.monolingualCorpus() != null) {
            RequestBody monolingualCorpusBody = RequestUtils.inputStreamBody(createModelOptions.monolingualCorpus(), "text/plain");
            multipartBuilder.addFormDataPart("monolingual_corpus", createModelOptions.monolingualCorpusFilename(), monolingualCorpusBody);
        }
        builder.body(multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TranslationModel.class));
    }

    public ServiceCall<Void> deleteModel(DeleteModelOptions deleteModelOptions) {
        Validator.notNull(deleteModelOptions, "deleteModelOptions cannot be null");
        String[] pathSegments = new String[]{"v2/models"};
        String[] pathParameters = new String[]{deleteModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<TranslationModel> getModel(GetModelOptions getModelOptions) {
        Validator.notNull(getModelOptions, "getModelOptions cannot be null");
        String[] pathSegments = new String[]{"v2/models"};
        String[] pathParameters = new String[]{getModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TranslationModel.class));
    }

    public ServiceCall<TranslationModels> listModels(ListModelsOptions listModelsOptions) {
        String[] pathSegments = new String[]{"v2/models"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (listModelsOptions != null) {
            if (listModelsOptions.source() != null) {
                builder.query("source", listModelsOptions.source());
            }
            if (listModelsOptions.target() != null) {
                builder.query("target", listModelsOptions.target());
            }
            if (listModelsOptions.defaultModels() != null) {
                builder.query("default", String.valueOf(listModelsOptions.defaultModels()));
            }
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(TranslationModels.class));
    }

    public ServiceCall<TranslationModels> listModels() {
        return this.listModels(null);
    }
}

