/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.http;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.InputStreamRequestBody;
import com.ibm.watson.developer_cloud.http.NameValue;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.StringHelper;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RequestBuilder {
    private RequestBody body;
    private HttpUrl httpUrl;
    private final List<NameValue> formParams = new ArrayList<NameValue>();
    private final List<NameValue> headers = new ArrayList<NameValue>();
    private final HTTPMethod method;
    private final List<NameValue> queryParams = new ArrayList<NameValue>();

    public static RequestBuilder delete(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.DELETE, url);
    }

    public static RequestBuilder get(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.GET, url);
    }

    public static RequestBuilder post(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.POST, url);
    }

    public static RequestBuilder put(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.PUT, url);
    }

    public static RequestBuilder patch(HttpUrl url) {
        return new RequestBuilder(HTTPMethod.PATCH, url);
    }

    public static HttpUrl constructHttpUrl(String endPoint, String[] pathSegments) {
        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse(endPoint).newBuilder();
        for (String segment : pathSegments) {
            httpUrlBuilder.addPathSegments(segment);
        }
        return httpUrlBuilder.build();
    }

    public static HttpUrl constructHttpUrl(String endPoint, String[] pathSegments, String[] pathParameters) {
        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse(endPoint).newBuilder();
        for (int i = 0; i < pathSegments.length; ++i) {
            httpUrlBuilder.addPathSegments(pathSegments[i]);
            if (i >= pathParameters.length) continue;
            httpUrlBuilder.addPathSegment(pathParameters[i]);
        }
        return httpUrlBuilder.build();
    }

    private RequestBuilder(HTTPMethod method, HttpUrl url) {
        this.method = method;
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this.httpUrl = url;
    }

    private RequestBuilder add(List<NameValue> params, String name, Object value) {
        if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.addParam(params, name, o);
            }
        } else if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.addParam(params, name, o);
            }
        } else {
            this.addParam(params, name, value);
        }
        return this;
    }

    private void addParam(List<NameValue> params, String name, Object value) {
        params.add(new NameValue(name, value == null ? null : String.valueOf(value)));
    }

    public Request build() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.toUrl());
        if (this.method == HTTPMethod.GET) {
            Validator.isNull(this.body, "cannot send a RequestBody in a GET request");
        } else if (!this.formParams.isEmpty()) {
            FormBody.Builder formBody = new FormBody.Builder();
            for (NameValue param : this.formParams) {
                String value = param.getValue() != null ? param.getValue() : "";
                formBody.add(param.getName(), value);
            }
            this.body = formBody.build();
        } else if (this.body == null) {
            this.body = RequestBody.create(null, new byte[0]);
        }
        builder.method(this.method.name(), this.body);
        builder.header("Accept", "application/json");
        for (NameValue header : this.headers) {
            builder.header(header.getName(), header.getValue());
        }
        return builder.build();
    }

    public String toString() {
        return "RequestBuilder [method=" + (Object)((Object)this.method) + ", formParams=" + this.formParams + ", headers=" + this.headers + ", queryParams=" + this.queryParams + ", httpUrl=" + this.httpUrl.toString() + "]";
    }

    private String toUrl() {
        HttpUrl.Builder builder = this.httpUrl.newBuilder();
        for (NameValue param : this.queryParams) {
            builder.addQueryParameter(param.getName(), param.getValue());
        }
        return builder.build().uri().toString();
    }

    private RequestBuilder with(List<NameValue> params, Object ... args) {
        if (args != null) {
            Validator.isTrue(args.length % 2 == 0, "need even number of arguments");
            for (int i = 0; i < args.length; i += 2) {
                this.add(params, args[i].toString(), args[i + 1]);
            }
        }
        return this;
    }

    public RequestBuilder body(RequestBody body) {
        this.body = body;
        return this;
    }

    public RequestBuilder bodyContent(String content, String contentType) {
        return this.body(RequestBody.create(MediaType.parse(contentType), content));
    }

    public RequestBuilder bodyContent(InputStream stream, String contentType) {
        return this.body(InputStreamRequestBody.create(MediaType.parse(contentType), stream));
    }

    public RequestBuilder bodyContent(String contentType, Object jsonContent, Object jsonPatchContent, InputStream nonJsonContent) {
        if (contentType != null) {
            if (WatsonService.isJsonMimeType(contentType)) {
                this.bodyContent(GsonSingleton.getGson().toJsonTree(jsonContent).getAsJsonObject().toString(), contentType);
            } else if (WatsonService.isJsonPatchMimeType(contentType)) {
                this.bodyContent(GsonSingleton.getGson().toJsonTree(jsonPatchContent).getAsJsonObject().toString(), contentType);
            } else {
                this.bodyContent(nonJsonContent, contentType);
            }
        }
        return this;
    }

    public RequestBuilder bodyContent(String contentType, Object jsonContent, Object jsonPatchContent, String nonJsonContent) {
        InputStream nonJson = null;
        if (nonJsonContent != null) {
            nonJson = StringHelper.toInputStream(nonJsonContent);
        }
        return this.bodyContent(contentType, jsonContent, jsonPatchContent, nonJson);
    }

    public RequestBuilder bodyJson(JsonObject json) {
        return this.bodyContent(json.toString(), "application/json");
    }

    public RequestBuilder bodyJson(JsonObject json, String mediaType) {
        return this.bodyContent(json.toString(), mediaType);
    }

    public RequestBuilder form(Object ... args) {
        return this.with(this.formParams, args);
    }

    public RequestBuilder header(Object ... args) {
        return this.with(this.headers, args);
    }

    public RequestBuilder query(Object ... args) {
        return this.with(this.queryParams, args);
    }

    private static enum HTTPMethod {
        DELETE,
        GET,
        POST,
        PUT,
        PATCH;

    }
}

