/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.query;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.ibm.watson.developer_cloud.discovery.v1.model.Calculation;
import com.ibm.watson.developer_cloud.discovery.v1.model.Filter;
import com.ibm.watson.developer_cloud.discovery.v1.model.Histogram;
import com.ibm.watson.developer_cloud.discovery.v1.model.Nested;
import com.ibm.watson.developer_cloud.discovery.v1.model.QueryAggregation;
import com.ibm.watson.developer_cloud.discovery.v1.model.Term;
import com.ibm.watson.developer_cloud.discovery.v1.model.Timeslice;
import com.ibm.watson.developer_cloud.discovery.v1.model.TopHits;
import com.ibm.watson.developer_cloud.discovery.v1.query.AggregationType;
import com.ibm.watson.developer_cloud.util.GsonSerializationHelper;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AggregationDeserializer
implements JsonDeserializer<QueryAggregation> {
    private static final String TYPE = "type";

    @Override
    public QueryAggregation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonReader in = new JsonReader(new StringReader(GsonSingleton.getGson().toJson(json)));
        HashMap<String, Object> aggregationMap = null;
        try {
            aggregationMap = this.getAggregationMap(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String aggregationType = (String)aggregationMap.get(TYPE);
        QueryAggregation aggregation = aggregationType.equals(AggregationType.HISTOGRAM.getName()) ? (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, Histogram.class) : (aggregationType.equals(AggregationType.MAX.getName()) || aggregationType.equals(AggregationType.MIN.getName()) || aggregationType.equals(AggregationType.AVERAGE.getName()) || aggregationType.equals(AggregationType.SUM.getName()) || aggregationType.equals(AggregationType.UNIQUE_COUNT.getName()) ? (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, Calculation.class) : (aggregationType.equals(AggregationType.TERM.getName()) ? (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, Term.class) : (aggregationType.equals(AggregationType.FILTER.getName()) ? (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, Filter.class) : (aggregationType.equals(AggregationType.NESTED.getName()) ? (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, Nested.class) : (aggregationType.equals(AggregationType.TIMESLICE.getName()) ? (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, Timeslice.class) : (aggregationType.equals(AggregationType.TOP_HITS.getName()) ? (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, TopHits.class) : (QueryAggregation)GsonSerializationHelper.serializeDynamicModelProperty(aggregationMap, QueryAggregation.class)))))));
        return aggregation;
    }

    private HashMap<String, Object> getAggregationMap(JsonReader in) throws IOException {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        while (in.peek() != JsonToken.END_DOCUMENT) {
            this.parseNext(in, objMap);
        }
        return objMap;
    }

    private void parseNext(JsonReader in, HashMap<String, Object> objMap) throws IOException {
        JsonToken token = in.peek();
        String lastName = "";
        if (token == JsonToken.NAME) {
            lastName = in.nextName();
            token = in.peek();
        }
        switch (token) {
            case BEGIN_ARRAY: {
                this.parseArray(in, objMap, lastName);
                break;
            }
            case BEGIN_OBJECT: {
                this.parseObject(in, objMap, lastName);
                break;
            }
            case STRING: {
                objMap.put(lastName, in.nextString());
                break;
            }
            case NUMBER: {
                objMap.put(lastName, in.nextDouble());
                break;
            }
            case BOOLEAN: {
                objMap.put(lastName, in.nextBoolean());
                break;
            }
            default: {
                throw new IOException("Unexpected JSON token encountered");
            }
        }
        this.collapseMap(objMap);
    }

    private void parseArray(JsonReader in, HashMap<String, Object> objMap, String name) throws IOException {
        ArrayList<HashMap<String, Object>> array = new ArrayList<HashMap<String, Object>>();
        in.beginArray();
        while (in.peek() != JsonToken.END_ARRAY) {
            HashMap<String, Object> arrayItem = new HashMap<String, Object>();
            this.parseNext(in, arrayItem);
            array.add(arrayItem);
        }
        in.endArray();
        objMap.put(name, array);
    }

    private void parseObject(JsonReader in, HashMap<String, Object> objMap, String name) throws IOException {
        HashMap<String, Object> innerObject = new HashMap<String, Object>();
        in.beginObject();
        while (in.peek() != JsonToken.END_OBJECT) {
            this.parseNext(in, innerObject);
        }
        in.endObject();
        objMap.put(name, innerObject);
    }

    private void collapseMap(HashMap<String, Object> objMap) {
        while (objMap.keySet().size() == 1 && objMap.keySet().contains("")) {
            HashMap innerMap = (HashMap)objMap.get("");
            objMap.clear();
            objMap.putAll(innerMap);
        }
    }
}

