/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class UpdateEnvironmentOptions
extends GenericModel {
    private String environmentId;
    private String name;
    private String description;

    private UpdateEnvironmentOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public static class Builder {
        private String environmentId;
        private String name;
        private String description;

        private Builder(UpdateEnvironmentOptions updateEnvironmentOptions) {
            this.environmentId = updateEnvironmentOptions.environmentId;
            this.name = updateEnvironmentOptions.name;
            this.description = updateEnvironmentOptions.description;
        }

        public Builder() {
        }

        public Builder(String environmentId) {
            this.environmentId = environmentId;
        }

        public UpdateEnvironmentOptions build() {
            return new UpdateEnvironmentOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }
    }
}

