/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ListFieldsOptions
extends GenericModel {
    private String environmentId;
    private List<String> collectionIds;

    private ListFieldsOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notNull(builder.collectionIds, "collectionIds cannot be null");
        this.environmentId = builder.environmentId;
        this.collectionIds = builder.collectionIds;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public static class Builder {
        private String environmentId;
        private List<String> collectionIds;

        private Builder(ListFieldsOptions listFieldsOptions) {
            this.environmentId = listFieldsOptions.environmentId;
            this.collectionIds = listFieldsOptions.collectionIds;
        }

        public Builder() {
        }

        public Builder(String environmentId, List<String> collectionIds) {
            this.environmentId = environmentId;
            this.collectionIds = collectionIds;
        }

        public ListFieldsOptions build() {
            return new ListFieldsOptions(this);
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull(collectionIds, "collectionIds cannot be null");
            if (this.collectionIds == null) {
                this.collectionIds = new ArrayList<String>();
            }
            this.collectionIds.add(collectionIds);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }
    }
}

