/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetConfigurationOptions
extends GenericModel {
    private String environmentId;
    private String configurationId;

    private GetConfigurationOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.configurationId, "configurationId cannot be empty");
        this.environmentId = builder.environmentId;
        this.configurationId = builder.configurationId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public static class Builder {
        private String environmentId;
        private String configurationId;

        private Builder(GetConfigurationOptions getConfigurationOptions) {
            this.environmentId = getConfigurationOptions.environmentId;
            this.configurationId = getConfigurationOptions.configurationId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String configurationId) {
            this.environmentId = environmentId;
            this.configurationId = configurationId;
        }

        public GetConfigurationOptions build() {
            return new GetConfigurationOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }
    }
}

