/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.discovery.v1.model.Expansion;
import com.ibm.watson.developer_cloud.discovery.v1.model.Expansions;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateExpansionsOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private List<Expansion> expansions;

    private CreateExpansionsOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.expansions = builder.expansions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<Expansion> expansions() {
        return this.expansions;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private List<Expansion> expansions;

        private Builder(CreateExpansionsOptions createExpansionsOptions) {
            this.environmentId = createExpansionsOptions.environmentId;
            this.collectionId = createExpansionsOptions.collectionId;
            this.expansions = createExpansionsOptions.expansions;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public CreateExpansionsOptions build() {
            return new CreateExpansionsOptions(this);
        }

        public Builder addExpansions(Expansion expansions) {
            Validator.notNull(expansions, "expansions cannot be null");
            if (this.expansions == null) {
                this.expansions = new ArrayList<Expansion>();
            }
            this.expansions.add(expansions);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder expansions(List<Expansion> expansions) {
            this.expansions = expansions;
            return this;
        }

        public Builder expansions(Expansions expansions) {
            this.expansions = expansions.getExpansions();
            return this;
        }
    }
}

