/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.discovery.v1.model.Configuration;
import com.ibm.watson.developer_cloud.discovery.v1.model.Conversions;
import com.ibm.watson.developer_cloud.discovery.v1.model.Enrichment;
import com.ibm.watson.developer_cloud.discovery.v1.model.NormalizationOperation;
import com.ibm.watson.developer_cloud.discovery.v1.model.Source;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateConfigurationOptions
extends GenericModel {
    private String environmentId;
    private String name;
    private String description;
    private Conversions conversions;
    private List<Enrichment> enrichments;
    private List<NormalizationOperation> normalizations;
    private Source source;

    private CreateConfigurationOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
        this.conversions = builder.conversions;
        this.enrichments = builder.enrichments;
        this.normalizations = builder.normalizations;
        this.source = builder.source;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Conversions conversions() {
        return this.conversions;
    }

    public List<Enrichment> enrichments() {
        return this.enrichments;
    }

    public List<NormalizationOperation> normalizations() {
        return this.normalizations;
    }

    public Source source() {
        return this.source;
    }

    public static class Builder {
        private String environmentId;
        private String name;
        private String description;
        private Conversions conversions;
        private List<Enrichment> enrichments;
        private List<NormalizationOperation> normalizations;
        private Source source;

        private Builder(CreateConfigurationOptions createConfigurationOptions) {
            this.environmentId = createConfigurationOptions.environmentId;
            this.name = createConfigurationOptions.name;
            this.description = createConfigurationOptions.description;
            this.conversions = createConfigurationOptions.conversions;
            this.enrichments = createConfigurationOptions.enrichments;
            this.normalizations = createConfigurationOptions.normalizations;
            this.source = createConfigurationOptions.source;
        }

        public Builder() {
        }

        public Builder(String environmentId) {
            this.environmentId = environmentId;
        }

        public CreateConfigurationOptions build() {
            return new CreateConfigurationOptions(this);
        }

        public Builder addEnrichments(Enrichment enrichments) {
            Validator.notNull(enrichments, "enrichments cannot be null");
            if (this.enrichments == null) {
                this.enrichments = new ArrayList<Enrichment>();
            }
            this.enrichments.add(enrichments);
            return this;
        }

        public Builder addNormalizations(NormalizationOperation normalizations) {
            Validator.notNull(normalizations, "normalizations cannot be null");
            if (this.normalizations == null) {
                this.normalizations = new ArrayList<NormalizationOperation>();
            }
            this.normalizations.add(normalizations);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder conversions(Conversions conversions) {
            this.conversions = conversions;
            return this;
        }

        public Builder enrichments(List<Enrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }

        public Builder normalizations(List<NormalizationOperation> normalizations) {
            this.normalizations = normalizations;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.name = configuration.getName();
            this.description = configuration.getDescription();
            this.conversions = configuration.getConversions();
            this.enrichments = configuration.getEnrichments();
            this.normalizations = configuration.getNormalizations();
            this.source = configuration.getSource();
            return this;
        }
    }
}

