/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.discovery.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class AddDocumentOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private InputStream file;
    private String filename;
    private String metadata;
    private String fileContentType;

    private AddDocumentOptions(Builder builder) {
        Validator.notEmpty(builder.environmentId, "environmentId cannot be empty");
        Validator.notEmpty(builder.collectionId, "collectionId cannot be empty");
        Validator.isTrue(builder.file == null || builder.filename != null, "filename cannot be null if file is not null.");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.file = builder.file;
        this.filename = builder.filename;
        this.metadata = builder.metadata;
        this.fileContentType = builder.fileContentType;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public InputStream file() {
        return this.file;
    }

    public String filename() {
        return this.filename;
    }

    public String metadata() {
        return this.metadata;
    }

    public String fileContentType() {
        return this.fileContentType;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private InputStream file;
        private String filename;
        private String metadata;
        private String fileContentType;

        private Builder(AddDocumentOptions addDocumentOptions) {
            this.environmentId = addDocumentOptions.environmentId;
            this.collectionId = addDocumentOptions.collectionId;
            this.file = addDocumentOptions.file;
            this.filename = addDocumentOptions.filename;
            this.metadata = addDocumentOptions.metadata;
            this.fileContentType = addDocumentOptions.fileContentType;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public AddDocumentOptions build() {
            return new AddDocumentOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }
}

