/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.conversation.v1.model.CreateValue;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateEntityOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private Boolean newFuzzyMatch;
    private String newEntity;
    private Map newMetadata;
    private List<CreateValue> newValues;
    private String newDescription;

    private UpdateEntityOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.entity, "entity cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.newFuzzyMatch = builder.newFuzzyMatch;
        this.newEntity = builder.newEntity;
        this.newMetadata = builder.newMetadata;
        this.newValues = builder.newValues;
        this.newDescription = builder.newDescription;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public Boolean newFuzzyMatch() {
        return this.newFuzzyMatch;
    }

    public String newEntity() {
        return this.newEntity;
    }

    public Map newMetadata() {
        return this.newMetadata;
    }

    public List<CreateValue> newValues() {
        return this.newValues;
    }

    public String newDescription() {
        return this.newDescription;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private Boolean newFuzzyMatch;
        private String newEntity;
        private Map newMetadata;
        private List<CreateValue> newValues;
        private String newDescription;

        private Builder(UpdateEntityOptions updateEntityOptions) {
            this.workspaceId = updateEntityOptions.workspaceId;
            this.entity = updateEntityOptions.entity;
            this.newFuzzyMatch = updateEntityOptions.newFuzzyMatch;
            this.newEntity = updateEntityOptions.newEntity;
            this.newMetadata = updateEntityOptions.newMetadata;
            this.newValues = updateEntityOptions.newValues;
            this.newDescription = updateEntityOptions.newDescription;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity) {
            this.workspaceId = workspaceId;
            this.entity = entity;
        }

        public UpdateEntityOptions build() {
            return new UpdateEntityOptions(this);
        }

        public Builder addValue(CreateValue value) {
            Validator.notNull(value, "value cannot be null");
            if (this.newValues == null) {
                this.newValues = new ArrayList<CreateValue>();
            }
            this.newValues.add(value);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder newFuzzyMatch(Boolean newFuzzyMatch) {
            this.newFuzzyMatch = newFuzzyMatch;
            return this;
        }

        public Builder newEntity(String newEntity) {
            this.newEntity = newEntity;
            return this;
        }

        public Builder newMetadata(Map newMetadata) {
            this.newMetadata = newMetadata;
            return this;
        }

        public Builder newValues(List<CreateValue> newValues) {
            this.newValues = newValues;
            return this;
        }

        public Builder newDescription(String newDescription) {
            this.newDescription = newDescription;
            return this;
        }
    }
}

