/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetValueOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;
    private Boolean export;
    private Boolean includeAudit;

    private GetValueOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.entity, "entity cannot be empty");
        Validator.notEmpty(builder.value, "value cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.export = builder.export;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public Boolean export() {
        return this.export;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private Boolean export;
        private Boolean includeAudit;

        private Builder(GetValueOptions getValueOptions) {
            this.workspaceId = getValueOptions.workspaceId;
            this.entity = getValueOptions.entity;
            this.value = getValueOptions.value;
            this.export = getValueOptions.export;
            this.includeAudit = getValueOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public GetValueOptions build() {
            return new GetValueOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder export(Boolean export) {
            this.export = export;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

