/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.conversation.v1.model;

import com.ibm.watson.developer_cloud.conversation.v1.model.Mentions;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateExample
extends GenericModel {
    private String text;
    private List<Mentions> mentions;

    private CreateExample(Builder builder) {
        Validator.notNull(builder.text, "text cannot be null");
        this.text = builder.text;
        this.mentions = builder.mentions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public List<Mentions> mentions() {
        return this.mentions;
    }

    public static class Builder {
        private String text;
        private List<Mentions> mentions;

        private Builder(CreateExample createExample) {
            this.text = createExample.text;
            this.mentions = createExample.mentions;
        }

        public Builder() {
        }

        public Builder(String text) {
            this.text = text;
        }

        public CreateExample build() {
            return new CreateExample(this);
        }

        public Builder addMentions(Mentions mentions) {
            Validator.notNull(mentions, "mentions cannot be null");
            if (this.mentions == null) {
                this.mentions = new ArrayList<Mentions>();
            }
            this.mentions.add(mentions);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder mentions(List<Mentions> mentions) {
            this.mentions = mentions;
            return this;
        }
    }
}

