/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v2;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.assistant.v2.model.CreateSessionOptions;
import com.ibm.watson.developer_cloud.assistant.v2.model.DeleteSessionOptions;
import com.ibm.watson.developer_cloud.assistant.v2.model.MessageOptions;
import com.ibm.watson.developer_cloud.assistant.v2.model.MessageResponse;
import com.ibm.watson.developer_cloud.assistant.v2.model.SessionResponse;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;

public class Assistant
extends WatsonService {
    private static final String SERVICE_NAME = "assistant";
    private static final String URL = "https://gateway.watsonplatform.net/assistant/api";
    private String versionDate;

    public Assistant(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue(versionDate != null && !versionDate.isEmpty(), "version cannot be null.");
        this.versionDate = versionDate;
    }

    public Assistant(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public Assistant(String versionDate, IamOptions iamOptions) {
        this(versionDate);
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<SessionResponse> createSession(CreateSessionOptions createSessionOptions) {
        Validator.notNull(createSessionOptions, "createSessionOptions cannot be null");
        String[] pathSegments = new String[]{"v2/assistants", "sessions"};
        String[] pathParameters = new String[]{createSessionOptions.assistantId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(SessionResponse.class));
    }

    public ServiceCall<Void> deleteSession(DeleteSessionOptions deleteSessionOptions) {
        Validator.notNull(deleteSessionOptions, "deleteSessionOptions cannot be null");
        String[] pathSegments = new String[]{"v2/assistants", "sessions"};
        String[] pathParameters = new String[]{deleteSessionOptions.assistantId(), deleteSessionOptions.sessionId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<MessageResponse> message(MessageOptions messageOptions) {
        Validator.notNull(messageOptions, "messageOptions cannot be null");
        String[] pathSegments = new String[]{"v2/assistants", "sessions", "message"};
        String[] pathParameters = new String[]{messageOptions.assistantId(), messageOptions.sessionId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        builder.query("version", this.versionDate);
        JsonObject contentJson = new JsonObject();
        if (messageOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree(messageOptions.input()));
        }
        if (messageOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree(messageOptions.context()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MessageResponse.class));
    }
}

