/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.assistant.v1.model.CreateExample;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class UpdateIntentOptions
extends GenericModel {
    private String workspaceId;
    private String intent;
    private String newIntent;
    private List<CreateExample> newExamples;
    private String newDescription;

    private UpdateIntentOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.intent, "intent cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.newIntent = builder.newIntent;
        this.newExamples = builder.newExamples;
        this.newDescription = builder.newDescription;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public String newIntent() {
        return this.newIntent;
    }

    public List<CreateExample> newExamples() {
        return this.newExamples;
    }

    public String newDescription() {
        return this.newDescription;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private String newIntent;
        private List<CreateExample> newExamples;
        private String newDescription;

        private Builder(UpdateIntentOptions updateIntentOptions) {
            this.workspaceId = updateIntentOptions.workspaceId;
            this.intent = updateIntentOptions.intent;
            this.newIntent = updateIntentOptions.newIntent;
            this.newExamples = updateIntentOptions.newExamples;
            this.newDescription = updateIntentOptions.newDescription;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent) {
            this.workspaceId = workspaceId;
            this.intent = intent;
        }

        public UpdateIntentOptions build() {
            return new UpdateIntentOptions(this);
        }

        public Builder addExample(CreateExample example) {
            Validator.notNull(example, "example cannot be null");
            if (this.newExamples == null) {
                this.newExamples = new ArrayList<CreateExample>();
            }
            this.newExamples.add(example);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder newIntent(String newIntent) {
            this.newIntent = newIntent;
            return this;
        }

        public Builder newExamples(List<CreateExample> newExamples) {
            this.newExamples = newExamples;
            return this;
        }

        public Builder newDescription(String newDescription) {
            this.newDescription = newDescription;
            return this;
        }
    }
}

