/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.assistant.v1.model.Context;
import com.ibm.watson.developer_cloud.assistant.v1.model.InputData;
import com.ibm.watson.developer_cloud.assistant.v1.model.MessageRequest;
import com.ibm.watson.developer_cloud.assistant.v1.model.OutputData;
import com.ibm.watson.developer_cloud.assistant.v1.model.RuntimeEntity;
import com.ibm.watson.developer_cloud.assistant.v1.model.RuntimeIntent;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class MessageOptions
extends GenericModel {
    private String workspaceId;
    private InputData input;
    private Boolean alternateIntents;
    private Context context;
    private List<RuntimeEntity> entities;
    private List<RuntimeIntent> intents;
    private OutputData output;
    private Boolean nodesVisitedDetails;

    private MessageOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.input = builder.input;
        this.alternateIntents = builder.alternateIntents;
        this.context = builder.context;
        this.entities = builder.entities;
        this.intents = builder.intents;
        this.output = builder.output;
        this.nodesVisitedDetails = builder.nodesVisitedDetails;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public InputData input() {
        return this.input;
    }

    public Boolean alternateIntents() {
        return this.alternateIntents;
    }

    public Context context() {
        return this.context;
    }

    public List<RuntimeEntity> entities() {
        return this.entities;
    }

    public List<RuntimeIntent> intents() {
        return this.intents;
    }

    public OutputData output() {
        return this.output;
    }

    public Boolean nodesVisitedDetails() {
        return this.nodesVisitedDetails;
    }

    public static class Builder {
        private String workspaceId;
        private InputData input;
        private Boolean alternateIntents;
        private Context context;
        private List<RuntimeEntity> entities;
        private List<RuntimeIntent> intents;
        private OutputData output;
        private Boolean nodesVisitedDetails;

        private Builder(MessageOptions messageOptions) {
            this.workspaceId = messageOptions.workspaceId;
            this.input = messageOptions.input;
            this.alternateIntents = messageOptions.alternateIntents;
            this.context = messageOptions.context;
            this.entities = messageOptions.entities;
            this.intents = messageOptions.intents;
            this.output = messageOptions.output;
            this.nodesVisitedDetails = messageOptions.nodesVisitedDetails;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public MessageOptions build() {
            return new MessageOptions(this);
        }

        public Builder addEntity(RuntimeEntity entity) {
            Validator.notNull(entity, "entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<RuntimeEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder addIntent(RuntimeIntent intent) {
            Validator.notNull(intent, "intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<RuntimeIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder input(InputData input) {
            this.input = input;
            return this;
        }

        public Builder alternateIntents(Boolean alternateIntents) {
            this.alternateIntents = alternateIntents;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder entities(List<RuntimeEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder intents(List<RuntimeIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder output(OutputData output) {
            this.output = output;
            return this;
        }

        public Builder nodesVisitedDetails(Boolean nodesVisitedDetails) {
            this.nodesVisitedDetails = nodesVisitedDetails;
            return this;
        }

        public Builder messageRequest(MessageRequest messageRequest) {
            this.input = messageRequest.getInput();
            this.alternateIntents = messageRequest.isAlternateIntents();
            this.context = messageRequest.getContext();
            this.entities = messageRequest.getEntities();
            this.intents = messageRequest.getIntents();
            this.output = messageRequest.getOutput();
            return this;
        }
    }
}

