/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class ListSynonymsOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;
    private Long pageLimit;
    private Boolean includeCount;
    private String sort;
    private String cursor;
    private Boolean includeAudit;

    private ListSynonymsOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.entity, "entity cannot be empty");
        Validator.notEmpty(builder.value, "value cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.pageLimit = builder.pageLimit;
        this.includeCount = builder.includeCount;
        this.sort = builder.sort;
        this.cursor = builder.cursor;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public Boolean includeCount() {
        return this.includeCount;
    }

    public String sort() {
        return this.sort;
    }

    public String cursor() {
        return this.cursor;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private Long pageLimit;
        private Boolean includeCount;
        private String sort;
        private String cursor;
        private Boolean includeAudit;

        private Builder(ListSynonymsOptions listSynonymsOptions) {
            this.workspaceId = listSynonymsOptions.workspaceId;
            this.entity = listSynonymsOptions.entity;
            this.value = listSynonymsOptions.value;
            this.pageLimit = listSynonymsOptions.pageLimit;
            this.includeCount = listSynonymsOptions.includeCount;
            this.sort = listSynonymsOptions.sort;
            this.cursor = listSynonymsOptions.cursor;
            this.includeAudit = listSynonymsOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public ListSynonymsOptions build() {
            return new ListSynonymsOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder includeCount(Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

