/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class DeleteValueOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;

    private DeleteValueOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.entity, "entity cannot be empty");
        Validator.notEmpty(builder.value, "value cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;

        private Builder(DeleteValueOptions deleteValueOptions) {
            this.workspaceId = deleteValueOptions.workspaceId;
            this.entity = deleteValueOptions.entity;
            this.value = deleteValueOptions.value;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public DeleteValueOptions build() {
            return new DeleteValueOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }
    }
}

