/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.assistant.v1.model.Mentions;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateExampleOptions
extends GenericModel {
    private String workspaceId;
    private String intent;
    private String text;
    private List<Mentions> mentions;

    private CreateExampleOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notEmpty(builder.intent, "intent cannot be empty");
        Validator.notNull(builder.text, "text cannot be null");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.text = builder.text;
        this.mentions = builder.mentions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public String text() {
        return this.text;
    }

    public List<Mentions> mentions() {
        return this.mentions;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private String text;
        private List<Mentions> mentions;

        private Builder(CreateExampleOptions createExampleOptions) {
            this.workspaceId = createExampleOptions.workspaceId;
            this.intent = createExampleOptions.intent;
            this.text = createExampleOptions.text;
            this.mentions = createExampleOptions.mentions;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent, String text) {
            this.workspaceId = workspaceId;
            this.intent = intent;
            this.text = text;
        }

        public CreateExampleOptions build() {
            return new CreateExampleOptions(this);
        }

        public Builder addMentions(Mentions mentions) {
            Validator.notNull(mentions, "mentions cannot be null");
            if (this.mentions == null) {
                this.mentions = new ArrayList<Mentions>();
            }
            this.mentions.add(mentions);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder mentions(List<Mentions> mentions) {
            this.mentions = mentions;
            return this;
        }
    }
}

