/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.assistant.v1.model.CreateValue;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateEntityOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String description;
    private Map metadata;
    private List<CreateValue> values;
    private Boolean fuzzyMatch;

    private CreateEntityOptions(Builder builder) {
        Validator.notEmpty(builder.workspaceId, "workspaceId cannot be empty");
        Validator.notNull(builder.entity, "entity cannot be null");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.description = builder.description;
        this.metadata = builder.metadata;
        this.values = builder.values;
        this.fuzzyMatch = builder.fuzzyMatch;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String description() {
        return this.description;
    }

    public Map metadata() {
        return this.metadata;
    }

    public List<CreateValue> values() {
        return this.values;
    }

    public Boolean fuzzyMatch() {
        return this.fuzzyMatch;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String description;
        private Map metadata;
        private List<CreateValue> values;
        private Boolean fuzzyMatch;

        private Builder(CreateEntityOptions createEntityOptions) {
            this.workspaceId = createEntityOptions.workspaceId;
            this.entity = createEntityOptions.entity;
            this.description = createEntityOptions.description;
            this.metadata = createEntityOptions.metadata;
            this.values = createEntityOptions.values;
            this.fuzzyMatch = createEntityOptions.fuzzyMatch;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity) {
            this.workspaceId = workspaceId;
            this.entity = entity;
        }

        public CreateEntityOptions build() {
            return new CreateEntityOptions(this);
        }

        public Builder addValue(CreateValue value) {
            Validator.notNull(value, "value cannot be null");
            if (this.values == null) {
                this.values = new ArrayList<CreateValue>();
            }
            this.values.add(value);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder metadata(Map metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder values(List<CreateValue> values) {
            this.values = values;
            return this;
        }

        public Builder fuzzyMatch(Boolean fuzzyMatch) {
            this.fuzzyMatch = fuzzyMatch;
            return this;
        }
    }
}

