/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class DetectFacesOptions
extends GenericModel {
    private InputStream imagesFile;
    private String imagesFilename;
    private String url;
    private String imagesFileContentType;
    @Deprecated
    private String parameters;

    private DetectFacesOptions(Builder builder) {
        this.imagesFile = builder.imagesFile;
        this.imagesFilename = builder.imagesFilename;
        this.url = builder.url;
        this.imagesFileContentType = builder.imagesFileContentType;
        this.parameters = builder.parameters;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream imagesFile() {
        return this.imagesFile;
    }

    public String imagesFilename() {
        return this.imagesFilename;
    }

    public String url() {
        return this.url;
    }

    public String imagesFileContentType() {
        return this.imagesFileContentType;
    }

    public String parameters() {
        return this.parameters;
    }

    public static class Builder {
        private InputStream imagesFile;
        private String imagesFilename;
        private String url;
        private String imagesFileContentType;
        @Deprecated
        private String parameters;

        private Builder(DetectFacesOptions detectFacesOptions) {
            this.imagesFile = detectFacesOptions.imagesFile;
            this.imagesFilename = detectFacesOptions.imagesFilename;
            this.url = detectFacesOptions.url;
            this.imagesFileContentType = detectFacesOptions.imagesFileContentType;
            this.parameters = detectFacesOptions.parameters;
        }

        public Builder() {
        }

        public DetectFacesOptions build() {
            return new DetectFacesOptions(this);
        }

        public Builder imagesFile(InputStream imagesFile) {
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder imagesFilename(String imagesFilename) {
            this.imagesFilename = imagesFilename;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder imagesFileContentType(String imagesFileContentType) {
            this.imagesFileContentType = imagesFileContentType;
            return this;
        }

        public Builder imagesFile(File imagesFile) throws FileNotFoundException {
            this.imagesFile = new FileInputStream(imagesFile);
            this.imagesFilename = imagesFile.getName();
            return this;
        }

        public Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }
    }
}

