/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class CreateClassifierOptions
extends GenericModel {
    private String name;
    private Map<String, InputStream> positiveExamples;
    private Map<String, String> positiveExamplesFilename;
    private InputStream negativeExamples;
    private String negativeExamplesFilename;

    private CreateClassifierOptions(Builder builder) {
        Validator.notNull(builder.name, "name cannot be null");
        Validator.isTrue(builder.negativeExamples == null || builder.negativeExamplesFilename != null, "negativeExamplesFilename cannot be null if negativeExamples is not null.");
        Validator.isTrue(builder.positiveExamples != null && !builder.positiveExamples.isEmpty(), "positiveExamples cannot be null or empty");
        this.name = builder.name;
        this.positiveExamples = builder.positiveExamples;
        this.positiveExamplesFilename = builder.positiveExamplesFilename;
        this.negativeExamples = builder.negativeExamples;
        this.negativeExamplesFilename = builder.negativeExamplesFilename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public Map<String, InputStream> positiveExamples() {
        return this.positiveExamples;
    }

    public Map<String, String> positiveExamplesFilename() {
        return this.positiveExamplesFilename;
    }

    public InputStream negativeExamples() {
        return this.negativeExamples;
    }

    public String negativeExamplesFilename() {
        return this.negativeExamplesFilename;
    }

    public static class Builder {
        private String name;
        private Map<String, InputStream> positiveExamples;
        private Map<String, String> positiveExamplesFilename;
        private InputStream negativeExamples;
        private String negativeExamplesFilename;

        private Builder(CreateClassifierOptions createClassifierOptions) {
            this.name = createClassifierOptions.name;
            this.positiveExamples = createClassifierOptions.positiveExamples;
            this.positiveExamplesFilename = createClassifierOptions.positiveExamplesFilename;
            this.negativeExamples = createClassifierOptions.negativeExamples;
            this.negativeExamplesFilename = createClassifierOptions.negativeExamplesFilename;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public CreateClassifierOptions build() {
            return new CreateClassifierOptions(this);
        }

        public Builder addPositiveExamples(String classname, InputStream positiveExamples) {
            Validator.notNull(classname, "classname cannot be null");
            Validator.notNull(positiveExamples, "positiveExamples cannot be null");
            if (this.positiveExamples == null) {
                this.positiveExamples = new HashMap<String, InputStream>();
            }
            this.positiveExamples.put(classname, positiveExamples);
            return this;
        }

        public Builder addPositiveExamplesFilename(String classname, String positiveExamplesFilename) {
            Validator.notNull(classname, "classname cannot be null");
            Validator.notNull(positiveExamplesFilename, "positiveExamplesFilename cannot be null");
            if (this.positiveExamplesFilename == null) {
                this.positiveExamplesFilename = new HashMap<String, String>();
            }
            this.positiveExamplesFilename.put(classname, positiveExamplesFilename);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder positiveExamples(Map<String, InputStream> positiveExamples) {
            this.positiveExamples = positiveExamples;
            return this;
        }

        public Builder positiveExamplesFilename(Map<String, String> positiveExamplesFilename) {
            this.positiveExamplesFilename = positiveExamplesFilename;
            return this;
        }

        public Builder negativeExamples(InputStream negativeExamples) {
            this.negativeExamples = negativeExamples;
            return this;
        }

        public Builder negativeExamplesFilename(String negativeExamplesFilename) {
            this.negativeExamplesFilename = negativeExamplesFilename;
            return this;
        }

        public Builder addPositiveExamples(String classname, File positiveExamples) throws FileNotFoundException {
            this.addPositiveExamples(classname, new FileInputStream(positiveExamples));
            this.addPositiveExamplesFilename(classname, positiveExamples.getName());
            return this;
        }

        public Builder negativeExamples(File negativeExamples) throws FileNotFoundException {
            this.negativeExamples = new FileInputStream(negativeExamples);
            this.negativeExamplesFilename = negativeExamples.getName();
            return this;
        }

        public Builder addClass(String classname, File positiveExamples) throws FileNotFoundException {
            return this.addPositiveExamples(classname, positiveExamples);
        }
    }
}

