/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.text_to_speech.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class SynthesizeOptions
extends GenericModel {
    private String text;
    private String accept;
    private String voice;
    private String customizationId;

    private SynthesizeOptions(Builder builder) {
        Validator.notNull(builder.text, "text cannot be null");
        this.text = builder.text;
        this.accept = builder.accept;
        this.voice = builder.voice;
        this.customizationId = builder.customizationId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public String accept() {
        return this.accept;
    }

    public String voice() {
        return this.voice;
    }

    public String customizationId() {
        return this.customizationId;
    }

    public static class Builder {
        private String text;
        private String accept;
        private String voice;
        private String customizationId;

        private Builder(SynthesizeOptions synthesizeOptions) {
            this.text = synthesizeOptions.text;
            this.accept = synthesizeOptions.accept;
            this.voice = synthesizeOptions.voice;
            this.customizationId = synthesizeOptions.customizationId;
        }

        public Builder() {
        }

        public Builder(String text) {
            this.text = text;
        }

        public SynthesizeOptions build() {
            return new SynthesizeOptions(this);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder voice(String voice) {
            this.voice = voice;
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }
    }

    public static interface Voice {
        public static final String EN_US_ALLISONVOICE = "en-US_AllisonVoice";
        public static final String EN_US_LISAVOICE = "en-US_LisaVoice";
        public static final String EN_US_MICHAELVOICE = "en-US_MichaelVoice";
        public static final String EN_GB_KATEVOICE = "en-GB_KateVoice";
        public static final String ES_ES_ENRIQUEVOICE = "es-ES_EnriqueVoice";
        public static final String ES_ES_LAURAVOICE = "es-ES_LauraVoice";
        public static final String ES_LA_SOFIAVOICE = "es-LA_SofiaVoice";
        public static final String ES_US_SOFIAVOICE = "es-US_SofiaVoice";
        public static final String DE_DE_DIETERVOICE = "de-DE_DieterVoice";
        public static final String DE_DE_BIRGITVOICE = "de-DE_BirgitVoice";
        public static final String FR_FR_RENEEVOICE = "fr-FR_ReneeVoice";
        public static final String IT_IT_FRANCESCAVOICE = "it-IT_FrancescaVoice";
        public static final String JA_JP_EMIVOICE = "ja-JP_EmiVoice";
        public static final String PT_BR_ISABELAVOICE = "pt-BR_IsabelaVoice";
    }

    public static interface Accept {
        public static final String AUDIO_BASIC = "audio/basic";
        public static final String AUDIO_FLAC = "audio/flac";
        public static final String AUDIO_L16 = "audio/l16";
        public static final String AUDIO_OGG = "audio/ogg";
        public static final String AUDIO_OGG_CODECS_OPUS = "audio/ogg;codecs=opus";
        public static final String AUDIO_OGG_CODECS_VORBIS = "audio/ogg;codecs=vorbis";
        public static final String AUDIO_MP3 = "audio/mp3";
        public static final String AUDIO_MPEG = "audio/mpeg";
        public static final String AUDIO_MULAW = "audio/mulaw";
        public static final String AUDIO_WAV = "audio/wav";
        public static final String AUDIO_WEBM = "audio/webm";
        public static final String AUDIO_WEBM_CODECS_OPUS = "audio/webm;codecs=opus";
        public static final String AUDIO_WEBM_CODECS_VORBIS = "audio/webm;codecs=vorbis";
    }
}

