/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.text_to_speech.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.AddWordOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.AddWordsOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.CreateVoiceModelOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.DeleteUserDataOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.DeleteVoiceModelOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.DeleteWordOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.GetPronunciationOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.GetVoiceModelOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.GetVoiceOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.GetWordOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.ListVoiceModelsOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.ListVoicesOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.ListWordsOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Pronunciation;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.SynthesizeOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Translation;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.UpdateVoiceModelOptions;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Voice;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.VoiceModel;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.VoiceModels;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Voices;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Words;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.InputStream;

public class TextToSpeech
extends WatsonService {
    private static final String SERVICE_NAME = "text_to_speech";
    private static final String URL = "https://stream.watsonplatform.net/text-to-speech/api";

    public TextToSpeech() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public TextToSpeech(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public TextToSpeech(IamOptions iamOptions) {
        this();
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<Voice> getVoice(GetVoiceOptions getVoiceOptions) {
        Validator.notNull(getVoiceOptions, "getVoiceOptions cannot be null");
        String[] pathSegments = new String[]{"v1/voices"};
        String[] pathParameters = new String[]{getVoiceOptions.voice()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        if (getVoiceOptions.customizationId() != null) {
            builder.query("customization_id", getVoiceOptions.customizationId());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Voice.class));
    }

    public ServiceCall<Voices> listVoices(ListVoicesOptions listVoicesOptions) {
        String[] pathSegments = new String[]{"v1/voices"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (listVoicesOptions != null) {
            // empty if block
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Voices.class));
    }

    public ServiceCall<Voices> listVoices() {
        return this.listVoices(null);
    }

    public ServiceCall<InputStream> synthesize(SynthesizeOptions synthesizeOptions) {
        Validator.notNull(synthesizeOptions, "synthesizeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/synthesize"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (synthesizeOptions.accept() != null) {
            builder.header("Accept", synthesizeOptions.accept());
        }
        if (synthesizeOptions.voice() != null) {
            builder.query("voice", synthesizeOptions.voice());
        }
        if (synthesizeOptions.customizationId() != null) {
            builder.query("customization_id", synthesizeOptions.customizationId());
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", synthesizeOptions.text());
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getInputStream());
    }

    public ServiceCall<Pronunciation> getPronunciation(GetPronunciationOptions getPronunciationOptions) {
        Validator.notNull(getPronunciationOptions, "getPronunciationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/pronunciation"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("text", getPronunciationOptions.text());
        if (getPronunciationOptions.voice() != null) {
            builder.query("voice", getPronunciationOptions.voice());
        }
        if (getPronunciationOptions.format() != null) {
            builder.query("format", getPronunciationOptions.format());
        }
        if (getPronunciationOptions.customizationId() != null) {
            builder.query("customization_id", getPronunciationOptions.customizationId());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Pronunciation.class));
    }

    public ServiceCall<VoiceModel> createVoiceModel(CreateVoiceModelOptions createVoiceModelOptions) {
        Validator.notNull(createVoiceModelOptions, "createVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createVoiceModelOptions.name());
        if (createVoiceModelOptions.language() != null) {
            contentJson.addProperty("language", createVoiceModelOptions.language());
        }
        if (createVoiceModelOptions.description() != null) {
            contentJson.addProperty("description", createVoiceModelOptions.description());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(VoiceModel.class));
    }

    public ServiceCall<Void> deleteVoiceModel(DeleteVoiceModelOptions deleteVoiceModelOptions) {
        Validator.notNull(deleteVoiceModelOptions, "deleteVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{deleteVoiceModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<VoiceModel> getVoiceModel(GetVoiceModelOptions getVoiceModelOptions) {
        Validator.notNull(getVoiceModelOptions, "getVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{getVoiceModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(VoiceModel.class));
    }

    public ServiceCall<VoiceModels> listVoiceModels(ListVoiceModelsOptions listVoiceModelsOptions) {
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (listVoiceModelsOptions != null && listVoiceModelsOptions.language() != null) {
            builder.query("language", listVoiceModelsOptions.language());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(VoiceModels.class));
    }

    public ServiceCall<VoiceModels> listVoiceModels() {
        return this.listVoiceModels(null);
    }

    public ServiceCall<Void> updateVoiceModel(UpdateVoiceModelOptions updateVoiceModelOptions) {
        Validator.notNull(updateVoiceModelOptions, "updateVoiceModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{updateVoiceModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        JsonObject contentJson = new JsonObject();
        if (updateVoiceModelOptions.name() != null) {
            contentJson.addProperty("name", updateVoiceModelOptions.name());
        }
        if (updateVoiceModelOptions.description() != null) {
            contentJson.addProperty("description", updateVoiceModelOptions.description());
        }
        if (updateVoiceModelOptions.words() != null) {
            contentJson.add("words", GsonSingleton.getGson().toJsonTree(updateVoiceModelOptions.words()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> addWord(AddWordOptions addWordOptions) {
        Validator.notNull(addWordOptions, "addWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordOptions.customizationId(), addWordOptions.word()};
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        JsonObject contentJson = new JsonObject();
        if (addWordOptions.translation() != null) {
            contentJson.addProperty("translation", addWordOptions.translation());
        }
        if (addWordOptions.partOfSpeech() != null) {
            contentJson.addProperty("part_of_speech", addWordOptions.partOfSpeech());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> addWords(AddWordsOptions addWordsOptions) {
        Validator.notNull(addWordsOptions, "addWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        JsonObject contentJson = new JsonObject();
        if (addWordsOptions.words() != null) {
            contentJson.add("words", GsonSingleton.getGson().toJsonTree(addWordsOptions.words()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteWord(DeleteWordOptions deleteWordOptions) {
        Validator.notNull(deleteWordOptions, "deleteWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{deleteWordOptions.customizationId(), deleteWordOptions.word()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Translation> getWord(GetWordOptions getWordOptions) {
        Validator.notNull(getWordOptions, "getWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{getWordOptions.customizationId(), getWordOptions.word()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Translation.class));
    }

    public ServiceCall<Words> listWords(ListWordsOptions listWordsOptions) {
        Validator.notNull(listWordsOptions, "listWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{listWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Words.class));
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull(deleteUserDataOptions, "deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/user_data"};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("customer_id", deleteUserDataOptions.customerId());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }
}

