/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class TrainAcousticModelOptions
extends GenericModel {
    private String customizationId;
    private String customLanguageModelId;

    private TrainAcousticModelOptions(Builder builder) {
        Validator.notEmpty(builder.customizationId, "customizationId cannot be empty");
        this.customizationId = builder.customizationId;
        this.customLanguageModelId = builder.customLanguageModelId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String customLanguageModelId() {
        return this.customLanguageModelId;
    }

    public static class Builder {
        private String customizationId;
        private String customLanguageModelId;

        private Builder(TrainAcousticModelOptions trainAcousticModelOptions) {
            this.customizationId = trainAcousticModelOptions.customizationId;
            this.customLanguageModelId = trainAcousticModelOptions.customLanguageModelId;
        }

        public Builder() {
        }

        public Builder(String customizationId) {
            this.customizationId = customizationId;
        }

        public TrainAcousticModelOptions build() {
            return new TrainAcousticModelOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder customLanguageModelId(String customLanguageModelId) {
            this.customLanguageModelId = customLanguageModelId;
            return this;
        }
    }
}

