/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class ListWordsOptions
extends GenericModel {
    private String customizationId;
    private String wordType;
    private String sort;

    private ListWordsOptions(Builder builder) {
        Validator.notEmpty(builder.customizationId, "customizationId cannot be empty");
        this.customizationId = builder.customizationId;
        this.wordType = builder.wordType;
        this.sort = builder.sort;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String wordType() {
        return this.wordType;
    }

    public String sort() {
        return this.sort;
    }

    public static class Builder {
        private String customizationId;
        private String wordType;
        private String sort;

        private Builder(ListWordsOptions listWordsOptions) {
            this.customizationId = listWordsOptions.customizationId;
            this.wordType = listWordsOptions.wordType;
            this.sort = listWordsOptions.sort;
        }

        public Builder() {
        }

        public Builder(String customizationId) {
            this.customizationId = customizationId;
        }

        public ListWordsOptions build() {
            return new ListWordsOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder wordType(String wordType) {
            this.wordType = wordType;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }
    }

    public static interface Sort {
        public static final String ALPHABETICAL = "alphabetical";
        public static final String COUNT = "count";
    }

    public static interface WordType {
        public static final String ALL = "all";
        public static final String USER = "user";
        public static final String CORPORA = "corpora";
    }
}

