/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.CustomWord;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class AddWordsOptions
extends GenericModel {
    private String customizationId;
    private List<CustomWord> words;

    private AddWordsOptions(Builder builder) {
        Validator.notEmpty(builder.customizationId, "customizationId cannot be empty");
        Validator.notNull(builder.words, "words cannot be null");
        this.customizationId = builder.customizationId;
        this.words = builder.words;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public List<CustomWord> words() {
        return this.words;
    }

    public static class Builder {
        private String customizationId;
        private List<CustomWord> words;

        private Builder(AddWordsOptions addWordsOptions) {
            this.customizationId = addWordsOptions.customizationId;
            this.words = addWordsOptions.words;
        }

        public Builder() {
        }

        public Builder(String customizationId, List<CustomWord> words) {
            this.customizationId = customizationId;
            this.words = words;
        }

        public AddWordsOptions build() {
            return new AddWordsOptions(this);
        }

        public Builder addWords(CustomWord words) {
            Validator.notNull(words, "words cannot be null");
            if (this.words == null) {
                this.words = new ArrayList<CustomWord>();
            }
            this.words.add(words);
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder words(List<CustomWord> words) {
            this.words = words;
            return this;
        }
    }
}

