/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AcousticModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AcousticModels;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AddAudioOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AddCorpusOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AddWordOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AddWordsOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AudioListing;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.AudioResources;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.CheckJobOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.CheckJobsOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.Corpora;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.Corpus;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.CreateAcousticModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.CreateJobOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.CreateLanguageModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.DeleteAcousticModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.DeleteAudioOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.DeleteCorpusOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.DeleteJobOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.DeleteLanguageModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.DeleteUserDataOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.DeleteWordOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.GetAcousticModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.GetAudioOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.GetCorpusOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.GetLanguageModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.GetModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.GetWordOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.LanguageModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.LanguageModels;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ListAcousticModelsOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ListAudioOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ListCorporaOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ListLanguageModelsOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ListModelsOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ListWordsOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RecognitionJob;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RecognitionJobs;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RecognizeOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RegisterCallbackOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.RegisterStatus;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ResetAcousticModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.ResetLanguageModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModels;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechRecognitionResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.TrainAcousticModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.TrainLanguageModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.UnregisterCallbackOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.UpgradeAcousticModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.UpgradeLanguageModelOptions;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.Word;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.Words;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.RecognizeCallback;
import com.ibm.watson.developer_cloud.speech_to_text.v1.websocket.SpeechToTextWebSocketListener;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;

public class SpeechToText
extends WatsonService {
    private static final String SERVICE_NAME = "speech_to_text";
    private static final String URL = "https://stream.watsonplatform.net/speech-to-text/api";

    public SpeechToText() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public SpeechToText(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public SpeechToText(IamOptions iamOptions) {
        this();
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<SpeechModel> getModel(GetModelOptions getModelOptions) {
        Validator.notNull(getModelOptions, "getModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/models"};
        String[] pathParameters = new String[]{getModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(SpeechModel.class));
    }

    public ServiceCall<SpeechModels> listModels(ListModelsOptions listModelsOptions) {
        String[] pathSegments = new String[]{"v1/models"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (listModelsOptions != null) {
            // empty if block
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(SpeechModels.class));
    }

    public ServiceCall<SpeechModels> listModels() {
        return this.listModels(null);
    }

    public ServiceCall<SpeechRecognitionResults> recognize(RecognizeOptions recognizeOptions) {
        Validator.notNull(recognizeOptions, "recognizeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognize"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (recognizeOptions.contentType() != null) {
            builder.header("Content-Type", recognizeOptions.contentType());
        }
        if (recognizeOptions.model() != null) {
            builder.query("model", recognizeOptions.model());
        }
        if (recognizeOptions.languageCustomizationId() != null) {
            builder.query("language_customization_id", recognizeOptions.languageCustomizationId());
        }
        if (recognizeOptions.acousticCustomizationId() != null) {
            builder.query("acoustic_customization_id", recognizeOptions.acousticCustomizationId());
        }
        if (recognizeOptions.baseModelVersion() != null) {
            builder.query("base_model_version", recognizeOptions.baseModelVersion());
        }
        if (recognizeOptions.customizationWeight() != null) {
            builder.query("customization_weight", String.valueOf(recognizeOptions.customizationWeight()));
        }
        if (recognizeOptions.inactivityTimeout() != null) {
            builder.query("inactivity_timeout", String.valueOf(recognizeOptions.inactivityTimeout()));
        }
        if (recognizeOptions.keywords() != null) {
            builder.query("keywords", RequestUtils.join(recognizeOptions.keywords(), ","));
        }
        if (recognizeOptions.keywordsThreshold() != null) {
            builder.query("keywords_threshold", String.valueOf(recognizeOptions.keywordsThreshold()));
        }
        if (recognizeOptions.maxAlternatives() != null) {
            builder.query("max_alternatives", String.valueOf(recognizeOptions.maxAlternatives()));
        }
        if (recognizeOptions.wordAlternativesThreshold() != null) {
            builder.query("word_alternatives_threshold", String.valueOf(recognizeOptions.wordAlternativesThreshold()));
        }
        if (recognizeOptions.wordConfidence() != null) {
            builder.query("word_confidence", String.valueOf(recognizeOptions.wordConfidence()));
        }
        if (recognizeOptions.timestamps() != null) {
            builder.query("timestamps", String.valueOf(recognizeOptions.timestamps()));
        }
        if (recognizeOptions.profanityFilter() != null) {
            builder.query("profanity_filter", String.valueOf(recognizeOptions.profanityFilter()));
        }
        if (recognizeOptions.smartFormatting() != null) {
            builder.query("smart_formatting", String.valueOf(recognizeOptions.smartFormatting()));
        }
        if (recognizeOptions.speakerLabels() != null) {
            builder.query("speaker_labels", String.valueOf(recognizeOptions.speakerLabels()));
        }
        if (recognizeOptions.customizationId() != null) {
            builder.query("customization_id", recognizeOptions.customizationId());
        }
        builder.bodyContent(recognizeOptions.contentType(), null, null, recognizeOptions.audio());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(SpeechRecognitionResults.class));
    }

    public WebSocket recognizeUsingWebSocket(RecognizeOptions recognizeOptions, RecognizeCallback callback) {
        Validator.notNull(recognizeOptions, "recognizeOptions cannot be null");
        Validator.notNull(recognizeOptions.audio(), "audio cannot be null");
        Validator.notNull(callback, "callback cannot be null");
        HttpUrl.Builder urlBuilder = HttpUrl.parse(this.getEndPoint() + "/v1/recognize").newBuilder();
        if (recognizeOptions.model() != null) {
            urlBuilder.addQueryParameter("model", recognizeOptions.model());
        }
        if (recognizeOptions.customizationId() != null) {
            urlBuilder.addQueryParameter("customization_id", recognizeOptions.customizationId());
        }
        if (recognizeOptions.languageCustomizationId() != null) {
            urlBuilder.addQueryParameter("language_customization_id", recognizeOptions.languageCustomizationId());
        }
        if (recognizeOptions.acousticCustomizationId() != null) {
            urlBuilder.addQueryParameter("acoustic_customization_id", recognizeOptions.acousticCustomizationId());
        }
        if (recognizeOptions.baseModelVersion() != null) {
            urlBuilder.addQueryParameter("base_model_version", recognizeOptions.baseModelVersion());
        }
        if (recognizeOptions.customizationWeight() != null) {
            urlBuilder.addQueryParameter("customization_weight", String.valueOf(recognizeOptions.customizationWeight()));
        }
        String url = urlBuilder.toString().replace("https://", "wss://");
        Request.Builder builder = new Request.Builder().url(url);
        this.setAuthentication(builder);
        this.setDefaultHeaders(builder);
        OkHttpClient client = this.configureHttpClient();
        return client.newWebSocket(builder.build(), new SpeechToTextWebSocketListener(recognizeOptions, callback));
    }

    public ServiceCall<RecognitionJob> checkJob(CheckJobOptions checkJobOptions) {
        Validator.notNull(checkJobOptions, "checkJobOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognitions"};
        String[] pathParameters = new String[]{checkJobOptions.id()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(RecognitionJob.class));
    }

    public ServiceCall<RecognitionJobs> checkJobs(CheckJobsOptions checkJobsOptions) {
        String[] pathSegments = new String[]{"v1/recognitions"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (checkJobsOptions != null) {
            // empty if block
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(RecognitionJobs.class));
    }

    public ServiceCall<RecognitionJobs> checkJobs() {
        return this.checkJobs(null);
    }

    public ServiceCall<RecognitionJob> createJob(CreateJobOptions createJobOptions) {
        Validator.notNull(createJobOptions, "createJobOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognitions"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (createJobOptions.contentType() != null) {
            builder.header("Content-Type", createJobOptions.contentType());
        }
        if (createJobOptions.model() != null) {
            builder.query("model", createJobOptions.model());
        }
        if (createJobOptions.callbackUrl() != null) {
            builder.query("callback_url", createJobOptions.callbackUrl());
        }
        if (createJobOptions.events() != null) {
            builder.query("events", createJobOptions.events());
        }
        if (createJobOptions.userToken() != null) {
            builder.query("user_token", createJobOptions.userToken());
        }
        if (createJobOptions.resultsTtl() != null) {
            builder.query("results_ttl", String.valueOf(createJobOptions.resultsTtl()));
        }
        if (createJobOptions.languageCustomizationId() != null) {
            builder.query("language_customization_id", createJobOptions.languageCustomizationId());
        }
        if (createJobOptions.acousticCustomizationId() != null) {
            builder.query("acoustic_customization_id", createJobOptions.acousticCustomizationId());
        }
        if (createJobOptions.baseModelVersion() != null) {
            builder.query("base_model_version", createJobOptions.baseModelVersion());
        }
        if (createJobOptions.customizationWeight() != null) {
            builder.query("customization_weight", String.valueOf(createJobOptions.customizationWeight()));
        }
        if (createJobOptions.inactivityTimeout() != null) {
            builder.query("inactivity_timeout", String.valueOf(createJobOptions.inactivityTimeout()));
        }
        if (createJobOptions.keywords() != null) {
            builder.query("keywords", RequestUtils.join(createJobOptions.keywords(), ","));
        }
        if (createJobOptions.keywordsThreshold() != null) {
            builder.query("keywords_threshold", String.valueOf(createJobOptions.keywordsThreshold()));
        }
        if (createJobOptions.maxAlternatives() != null) {
            builder.query("max_alternatives", String.valueOf(createJobOptions.maxAlternatives()));
        }
        if (createJobOptions.wordAlternativesThreshold() != null) {
            builder.query("word_alternatives_threshold", String.valueOf(createJobOptions.wordAlternativesThreshold()));
        }
        if (createJobOptions.wordConfidence() != null) {
            builder.query("word_confidence", String.valueOf(createJobOptions.wordConfidence()));
        }
        if (createJobOptions.timestamps() != null) {
            builder.query("timestamps", String.valueOf(createJobOptions.timestamps()));
        }
        if (createJobOptions.profanityFilter() != null) {
            builder.query("profanity_filter", String.valueOf(createJobOptions.profanityFilter()));
        }
        if (createJobOptions.smartFormatting() != null) {
            builder.query("smart_formatting", String.valueOf(createJobOptions.smartFormatting()));
        }
        if (createJobOptions.speakerLabels() != null) {
            builder.query("speaker_labels", String.valueOf(createJobOptions.speakerLabels()));
        }
        if (createJobOptions.customizationId() != null) {
            builder.query("customization_id", createJobOptions.customizationId());
        }
        builder.bodyContent(createJobOptions.contentType(), null, null, createJobOptions.audio());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(RecognitionJob.class));
    }

    public ServiceCall<Void> deleteJob(DeleteJobOptions deleteJobOptions) {
        Validator.notNull(deleteJobOptions, "deleteJobOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognitions"};
        String[] pathParameters = new String[]{deleteJobOptions.id()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<RegisterStatus> registerCallback(RegisterCallbackOptions registerCallbackOptions) {
        Validator.notNull(registerCallbackOptions, "registerCallbackOptions cannot be null");
        String[] pathSegments = new String[]{"v1/register_callback"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("callback_url", registerCallbackOptions.callbackUrl());
        if (registerCallbackOptions.userSecret() != null) {
            builder.query("user_secret", registerCallbackOptions.userSecret());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(RegisterStatus.class));
    }

    public ServiceCall<Void> unregisterCallback(UnregisterCallbackOptions unregisterCallbackOptions) {
        Validator.notNull(unregisterCallbackOptions, "unregisterCallbackOptions cannot be null");
        String[] pathSegments = new String[]{"v1/unregister_callback"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("callback_url", unregisterCallbackOptions.callbackUrl());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<LanguageModel> createLanguageModel(CreateLanguageModelOptions createLanguageModelOptions) {
        Validator.notNull(createLanguageModelOptions, "createLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createLanguageModelOptions.name());
        contentJson.addProperty("base_model_name", createLanguageModelOptions.baseModelName());
        if (createLanguageModelOptions.dialect() != null) {
            contentJson.addProperty("dialect", createLanguageModelOptions.dialect());
        }
        if (createLanguageModelOptions.description() != null) {
            contentJson.addProperty("description", createLanguageModelOptions.description());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(LanguageModel.class));
    }

    public ServiceCall<Void> deleteLanguageModel(DeleteLanguageModelOptions deleteLanguageModelOptions) {
        Validator.notNull(deleteLanguageModelOptions, "deleteLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{deleteLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<LanguageModel> getLanguageModel(GetLanguageModelOptions getLanguageModelOptions) {
        Validator.notNull(getLanguageModelOptions, "getLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{getLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(LanguageModel.class));
    }

    public ServiceCall<LanguageModels> listLanguageModels(ListLanguageModelsOptions listLanguageModelsOptions) {
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (listLanguageModelsOptions != null && listLanguageModelsOptions.language() != null) {
            builder.query("language", listLanguageModelsOptions.language());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(LanguageModels.class));
    }

    public ServiceCall<LanguageModels> listLanguageModels() {
        return this.listLanguageModels(null);
    }

    public ServiceCall<Void> resetLanguageModel(ResetLanguageModelOptions resetLanguageModelOptions) {
        Validator.notNull(resetLanguageModelOptions, "resetLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "reset"};
        String[] pathParameters = new String[]{resetLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> trainLanguageModel(TrainLanguageModelOptions trainLanguageModelOptions) {
        Validator.notNull(trainLanguageModelOptions, "trainLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "train"};
        String[] pathParameters = new String[]{trainLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        if (trainLanguageModelOptions.wordTypeToAdd() != null) {
            builder.query("word_type_to_add", trainLanguageModelOptions.wordTypeToAdd());
        }
        if (trainLanguageModelOptions.customizationWeight() != null) {
            builder.query("customization_weight", String.valueOf(trainLanguageModelOptions.customizationWeight()));
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> upgradeLanguageModel(UpgradeLanguageModelOptions upgradeLanguageModelOptions) {
        Validator.notNull(upgradeLanguageModelOptions, "upgradeLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "upgrade_model"};
        String[] pathParameters = new String[]{upgradeLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> addCorpus(AddCorpusOptions addCorpusOptions) {
        Validator.notNull(addCorpusOptions, "addCorpusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{addCorpusOptions.customizationId(), addCorpusOptions.corpusName()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        if (addCorpusOptions.allowOverwrite() != null) {
            builder.query("allow_overwrite", String.valueOf(addCorpusOptions.allowOverwrite()));
        }
        builder.body(RequestUtils.inputStreamBody(addCorpusOptions.corpusFile(), "text/plain"));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteCorpus(DeleteCorpusOptions deleteCorpusOptions) {
        Validator.notNull(deleteCorpusOptions, "deleteCorpusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{deleteCorpusOptions.customizationId(), deleteCorpusOptions.corpusName()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Corpus> getCorpus(GetCorpusOptions getCorpusOptions) {
        Validator.notNull(getCorpusOptions, "getCorpusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{getCorpusOptions.customizationId(), getCorpusOptions.corpusName()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Corpus.class));
    }

    public ServiceCall<Corpora> listCorpora(ListCorporaOptions listCorporaOptions) {
        Validator.notNull(listCorporaOptions, "listCorporaOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{listCorporaOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Corpora.class));
    }

    public ServiceCall<Void> addWord(AddWordOptions addWordOptions) {
        Validator.notNull(addWordOptions, "addWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordOptions.customizationId(), addWordOptions.wordName()};
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        JsonObject contentJson = new JsonObject();
        if (addWordOptions.word() != null) {
            contentJson.addProperty("word", addWordOptions.word());
        }
        if (addWordOptions.soundsLike() != null) {
            contentJson.add("sounds_like", GsonSingleton.getGson().toJsonTree(addWordOptions.soundsLike()));
        }
        if (addWordOptions.displayAs() != null) {
            contentJson.addProperty("display_as", addWordOptions.displayAs());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> addWords(AddWordsOptions addWordsOptions) {
        Validator.notNull(addWordsOptions, "addWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        JsonObject contentJson = new JsonObject();
        contentJson.add("words", GsonSingleton.getGson().toJsonTree(addWordsOptions.words()));
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteWord(DeleteWordOptions deleteWordOptions) {
        Validator.notNull(deleteWordOptions, "deleteWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{deleteWordOptions.customizationId(), deleteWordOptions.wordName()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Word> getWord(GetWordOptions getWordOptions) {
        Validator.notNull(getWordOptions, "getWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{getWordOptions.customizationId(), getWordOptions.wordName()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Word.class));
    }

    public ServiceCall<Words> listWords(ListWordsOptions listWordsOptions) {
        Validator.notNull(listWordsOptions, "listWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{listWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        if (listWordsOptions.wordType() != null) {
            builder.query("word_type", listWordsOptions.wordType());
        }
        if (listWordsOptions.sort() != null) {
            builder.query("sort", listWordsOptions.sort());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Words.class));
    }

    public ServiceCall<AcousticModel> createAcousticModel(CreateAcousticModelOptions createAcousticModelOptions) {
        Validator.notNull(createAcousticModelOptions, "createAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createAcousticModelOptions.name());
        contentJson.addProperty("base_model_name", createAcousticModelOptions.baseModelName());
        if (createAcousticModelOptions.description() != null) {
            contentJson.addProperty("description", createAcousticModelOptions.description());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(AcousticModel.class));
    }

    public ServiceCall<Void> deleteAcousticModel(DeleteAcousticModelOptions deleteAcousticModelOptions) {
        Validator.notNull(deleteAcousticModelOptions, "deleteAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        String[] pathParameters = new String[]{deleteAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<AcousticModel> getAcousticModel(GetAcousticModelOptions getAcousticModelOptions) {
        Validator.notNull(getAcousticModelOptions, "getAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        String[] pathParameters = new String[]{getAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(AcousticModel.class));
    }

    public ServiceCall<AcousticModels> listAcousticModels(ListAcousticModelsOptions listAcousticModelsOptions) {
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        if (listAcousticModelsOptions != null && listAcousticModelsOptions.language() != null) {
            builder.query("language", listAcousticModelsOptions.language());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(AcousticModels.class));
    }

    public ServiceCall<AcousticModels> listAcousticModels() {
        return this.listAcousticModels(null);
    }

    public ServiceCall<Void> resetAcousticModel(ResetAcousticModelOptions resetAcousticModelOptions) {
        Validator.notNull(resetAcousticModelOptions, "resetAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "reset"};
        String[] pathParameters = new String[]{resetAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> trainAcousticModel(TrainAcousticModelOptions trainAcousticModelOptions) {
        Validator.notNull(trainAcousticModelOptions, "trainAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "train"};
        String[] pathParameters = new String[]{trainAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        if (trainAcousticModelOptions.customLanguageModelId() != null) {
            builder.query("custom_language_model_id", trainAcousticModelOptions.customLanguageModelId());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> upgradeAcousticModel(UpgradeAcousticModelOptions upgradeAcousticModelOptions) {
        Validator.notNull(upgradeAcousticModelOptions, "upgradeAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "upgrade_model"};
        String[] pathParameters = new String[]{upgradeAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        if (upgradeAcousticModelOptions.customLanguageModelId() != null) {
            builder.query("custom_language_model_id", upgradeAcousticModelOptions.customLanguageModelId());
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> addAudio(AddAudioOptions addAudioOptions) {
        Validator.notNull(addAudioOptions, "addAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{addAudioOptions.customizationId(), addAudioOptions.audioName()};
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        if (addAudioOptions.contentType() != null) {
            builder.header("Content-Type", addAudioOptions.contentType());
        }
        if (addAudioOptions.containedContentType() != null) {
            builder.header("Contained-Content-Type", addAudioOptions.containedContentType());
        }
        if (addAudioOptions.allowOverwrite() != null) {
            builder.query("allow_overwrite", String.valueOf(addAudioOptions.allowOverwrite()));
        }
        builder.bodyContent(addAudioOptions.contentType(), null, null, addAudioOptions.audioResource());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Void> deleteAudio(DeleteAudioOptions deleteAudioOptions) {
        Validator.notNull(deleteAudioOptions, "deleteAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{deleteAudioOptions.customizationId(), deleteAudioOptions.audioName()};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<AudioListing> getAudio(GetAudioOptions getAudioOptions) {
        Validator.notNull(getAudioOptions, "getAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{getAudioOptions.customizationId(), getAudioOptions.audioName()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(AudioListing.class));
    }

    public ServiceCall<AudioResources> listAudio(ListAudioOptions listAudioOptions) {
        Validator.notNull(listAudioOptions, "listAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{listAudioOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments, pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(AudioResources.class));
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull(deleteUserDataOptions, "deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/user_data"};
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.constructHttpUrl(this.getEndPoint(), pathSegments));
        builder.query("customer_id", deleteUserDataOptions.customerId());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }
}

