/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v3.model;

import com.ibm.watson.developer_cloud.personality_insights.v3.model.ContentItem;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Content
extends GenericModel {
    private List<ContentItem> contentItems;

    private Content(Builder builder) {
        Validator.notNull(builder.contentItems, "contentItems cannot be null");
        this.contentItems = builder.contentItems;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<ContentItem> contentItems() {
        return this.contentItems;
    }

    public static class Builder {
        private List<ContentItem> contentItems;

        private Builder(Content content) {
            this.contentItems = content.contentItems;
        }

        public Builder() {
        }

        public Builder(List<ContentItem> contentItems) {
            this.contentItems = contentItems;
        }

        public Content build() {
            return new Content(this);
        }

        public Builder addContentItem(ContentItem contentItem) {
            Validator.notNull(contentItem, "contentItem cannot be null");
            if (this.contentItems == null) {
                this.contentItems = new ArrayList<ContentItem>();
            }
            this.contentItems.add(contentItem);
            return this;
        }

        public Builder contentItems(List<ContentItem> contentItems) {
            this.contentItems = contentItems;
            return this;
        }
    }
}

