/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_understanding.v1.model;

import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.Features;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class AnalyzeOptions
extends GenericModel {
    private String text;
    private String html;
    private String url;
    private Features features;
    private Boolean clean;
    private String xpath;
    private Boolean fallbackToRaw;
    private Boolean returnAnalyzedText;
    private String language;
    private Long limitTextCharacters;

    private AnalyzeOptions(Builder builder) {
        Validator.notNull(builder.features, "features cannot be null");
        this.text = builder.text;
        this.html = builder.html;
        this.url = builder.url;
        this.features = builder.features;
        this.clean = builder.clean;
        this.xpath = builder.xpath;
        this.fallbackToRaw = builder.fallbackToRaw;
        this.returnAnalyzedText = builder.returnAnalyzedText;
        this.language = builder.language;
        this.limitTextCharacters = builder.limitTextCharacters;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public String html() {
        return this.html;
    }

    public String url() {
        return this.url;
    }

    public Features features() {
        return this.features;
    }

    public Boolean clean() {
        return this.clean;
    }

    public String xpath() {
        return this.xpath;
    }

    public Boolean fallbackToRaw() {
        return this.fallbackToRaw;
    }

    public Boolean returnAnalyzedText() {
        return this.returnAnalyzedText;
    }

    public String language() {
        return this.language;
    }

    public Long limitTextCharacters() {
        return this.limitTextCharacters;
    }

    public static class Builder {
        private String text;
        private String html;
        private String url;
        private Features features;
        private Boolean clean;
        private String xpath;
        private Boolean fallbackToRaw;
        private Boolean returnAnalyzedText;
        private String language;
        private Long limitTextCharacters;

        private Builder(AnalyzeOptions analyzeOptions) {
            this.text = analyzeOptions.text;
            this.html = analyzeOptions.html;
            this.url = analyzeOptions.url;
            this.features = analyzeOptions.features;
            this.clean = analyzeOptions.clean;
            this.xpath = analyzeOptions.xpath;
            this.fallbackToRaw = analyzeOptions.fallbackToRaw;
            this.returnAnalyzedText = analyzeOptions.returnAnalyzedText;
            this.language = analyzeOptions.language;
            this.limitTextCharacters = analyzeOptions.limitTextCharacters;
        }

        public Builder() {
        }

        public Builder(Features features) {
            this.features = features;
        }

        public AnalyzeOptions build() {
            return new AnalyzeOptions(this);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder html(String html) {
            this.html = html;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder features(Features features) {
            this.features = features;
            return this;
        }

        public Builder clean(Boolean clean) {
            this.clean = clean;
            return this;
        }

        public Builder xpath(String xpath) {
            this.xpath = xpath;
            return this;
        }

        public Builder fallbackToRaw(Boolean fallbackToRaw) {
            this.fallbackToRaw = fallbackToRaw;
            return this;
        }

        public Builder returnAnalyzedText(Boolean returnAnalyzedText) {
            this.returnAnalyzedText = returnAnalyzedText;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder limitTextCharacters(long limitTextCharacters) {
            this.limitTextCharacters = limitTextCharacters;
            return this;
        }
    }
}

