/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateClassifierOptions
extends GenericModel {
    private InputStream metadata;
    private String metadataFilename;
    private InputStream trainingData;
    private String trainingDataFilename;

    private CreateClassifierOptions(Builder builder) {
        Validator.notNull(builder.metadata, "metadata cannot be null");
        Validator.notNull(builder.trainingData, "trainingData cannot be null");
        this.metadata = builder.metadata;
        this.metadataFilename = builder.metadataFilename;
        this.trainingData = builder.trainingData;
        this.trainingDataFilename = builder.trainingDataFilename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream metadata() {
        return this.metadata;
    }

    public String metadataFilename() {
        return this.metadataFilename;
    }

    public InputStream trainingData() {
        return this.trainingData;
    }

    public String trainingDataFilename() {
        return this.trainingDataFilename;
    }

    public static class Builder {
        private InputStream metadata;
        private String metadataFilename;
        private InputStream trainingData;
        private String trainingDataFilename;

        private Builder(CreateClassifierOptions createClassifierOptions) {
            this.metadata = createClassifierOptions.metadata;
            this.metadataFilename = createClassifierOptions.metadataFilename;
            this.trainingData = createClassifierOptions.trainingData;
            this.trainingDataFilename = createClassifierOptions.trainingDataFilename;
        }

        public Builder() {
        }

        public Builder(InputStream metadata, InputStream trainingData) {
            this.metadata = metadata;
            this.trainingData = trainingData;
        }

        public CreateClassifierOptions build() {
            return new CreateClassifierOptions(this);
        }

        public Builder metadata(InputStream metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadataFilename(String metadataFilename) {
            this.metadataFilename = metadataFilename;
            return this;
        }

        public Builder trainingData(InputStream trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public Builder trainingDataFilename(String trainingDataFilename) {
            this.trainingDataFilename = trainingDataFilename;
            return this;
        }

        public Builder metadata(File metadata) throws FileNotFoundException {
            this.metadata = new FileInputStream(metadata);
            this.metadataFilename = metadata.getName();
            return this;
        }

        public Builder trainingData(File trainingData) throws FileNotFoundException {
            this.trainingData = new FileInputStream(trainingData);
            this.trainingDataFilename = trainingData.getName();
            return this;
        }
    }
}

