/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class ClassifyOptions
extends GenericModel {
    private String classifierId;
    private String text;

    private ClassifyOptions(Builder builder) {
        Validator.notEmpty(builder.classifierId, "classifierId cannot be empty");
        Validator.notNull(builder.text, "text cannot be null");
        this.classifierId = builder.classifierId;
        this.text = builder.text;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String classifierId() {
        return this.classifierId;
    }

    public String text() {
        return this.text;
    }

    public static class Builder {
        private String classifierId;
        private String text;

        private Builder(ClassifyOptions classifyOptions) {
            this.classifierId = classifyOptions.classifierId;
            this.text = classifyOptions.text;
        }

        public Builder() {
        }

        public Builder(String classifierId, String text) {
            this.classifierId = classifierId;
            this.text = text;
        }

        public ClassifyOptions build() {
            return new ClassifyOptions(this);
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }
    }
}

