/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.language_translator.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class TranslateOptions
extends GenericModel {
    private List<String> text;
    private String modelId;
    private String source;
    private String target;

    private TranslateOptions(Builder builder) {
        Validator.notNull(builder.text, "text cannot be null");
        this.text = builder.text;
        this.modelId = builder.modelId;
        this.source = builder.source;
        this.target = builder.target;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> text() {
        return this.text;
    }

    public String modelId() {
        return this.modelId;
    }

    public String source() {
        return this.source;
    }

    public String target() {
        return this.target;
    }

    public static class Builder {
        private List<String> text;
        private String modelId;
        private String source;
        private String target;

        private Builder(TranslateOptions translateOptions) {
            this.text = translateOptions.text;
            this.modelId = translateOptions.modelId;
            this.source = translateOptions.source;
            this.target = translateOptions.target;
        }

        public Builder() {
        }

        public Builder(List<String> text) {
            this.text = text;
        }

        public TranslateOptions build() {
            return new TranslateOptions(this);
        }

        public Builder addText(String text) {
            Validator.notNull(text, "text cannot be null");
            if (this.text == null) {
                this.text = new ArrayList<String>();
            }
            this.text.add(text);
            return this;
        }

        public Builder text(List<String> text) {
            this.text = text;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }
    }
}

