/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.language_translator.v3.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateModelOptions
extends GenericModel {
    private String baseModelId;
    private String name;
    private InputStream forcedGlossary;
    private String forcedGlossaryFilename;
    private InputStream parallelCorpus;
    private String parallelCorpusFilename;

    private CreateModelOptions(Builder builder) {
        Validator.notNull(builder.baseModelId, "baseModelId cannot be null");
        this.baseModelId = builder.baseModelId;
        this.name = builder.name;
        this.forcedGlossary = builder.forcedGlossary;
        this.forcedGlossaryFilename = builder.forcedGlossaryFilename;
        this.parallelCorpus = builder.parallelCorpus;
        this.parallelCorpusFilename = builder.parallelCorpusFilename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String baseModelId() {
        return this.baseModelId;
    }

    public String name() {
        return this.name;
    }

    public InputStream forcedGlossary() {
        return this.forcedGlossary;
    }

    public String forcedGlossaryFilename() {
        return this.forcedGlossaryFilename;
    }

    public InputStream parallelCorpus() {
        return this.parallelCorpus;
    }

    public String parallelCorpusFilename() {
        return this.parallelCorpusFilename;
    }

    public static class Builder {
        private String baseModelId;
        private String name;
        private InputStream forcedGlossary;
        private String forcedGlossaryFilename;
        private InputStream parallelCorpus;
        private String parallelCorpusFilename;

        private Builder(CreateModelOptions createModelOptions) {
            this.baseModelId = createModelOptions.baseModelId;
            this.name = createModelOptions.name;
            this.forcedGlossary = createModelOptions.forcedGlossary;
            this.forcedGlossaryFilename = createModelOptions.forcedGlossaryFilename;
            this.parallelCorpus = createModelOptions.parallelCorpus;
            this.parallelCorpusFilename = createModelOptions.parallelCorpusFilename;
        }

        public Builder() {
        }

        public Builder(String baseModelId) {
            this.baseModelId = baseModelId;
        }

        public CreateModelOptions build() {
            return new CreateModelOptions(this);
        }

        public Builder baseModelId(String baseModelId) {
            this.baseModelId = baseModelId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder forcedGlossary(InputStream forcedGlossary) {
            this.forcedGlossary = forcedGlossary;
            return this;
        }

        public Builder forcedGlossaryFilename(String forcedGlossaryFilename) {
            this.forcedGlossaryFilename = forcedGlossaryFilename;
            return this;
        }

        public Builder parallelCorpus(InputStream parallelCorpus) {
            this.parallelCorpus = parallelCorpus;
            return this;
        }

        public Builder parallelCorpusFilename(String parallelCorpusFilename) {
            this.parallelCorpusFilename = parallelCorpusFilename;
            return this;
        }

        public Builder forcedGlossary(File forcedGlossary) throws FileNotFoundException {
            this.forcedGlossary = new FileInputStream(forcedGlossary);
            this.forcedGlossaryFilename = forcedGlossary.getName();
            return this;
        }

        public Builder parallelCorpus(File parallelCorpus) throws FileNotFoundException {
            this.parallelCorpus = new FileInputStream(parallelCorpus);
            this.parallelCorpusFilename = parallelCorpus.getName();
            return this;
        }
    }
}

