/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.http;

import com.ibm.watson.developer_cloud.http.HttpConfigOptions;
import com.ibm.watson.developer_cloud.http.WatsonCookieJar;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.DelegatingSSLSocketFactory;
import com.ibm.watson.developer_cloud.util.HttpLogging;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class HttpClientSingleton {
    private static HttpClientSingleton instance = null;
    private static final Logger LOG = Logger.getLogger(WatsonService.class.getName());
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    private OkHttpClient okHttpClient = this.configureHttpClient();

    public static HttpClientSingleton getInstance() {
        if (instance == null) {
            instance = new HttpClientSingleton();
        }
        return instance;
    }

    protected HttpClientSingleton() {
    }

    private OkHttpClient configureHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.addCookieJar(builder);
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.writeTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(90L, TimeUnit.SECONDS);
        builder.addNetworkInterceptor(HttpLogging.getLoggingInterceptor());
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledCipherSuites().build();
        builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        this.setupTLSProtocol(builder);
        return builder.build();
    }

    private void addCookieJar(OkHttpClient.Builder builder) {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        builder.cookieJar(new WatsonCookieJar(cookieManager));
    }

    private void disableSslVerification() {
        SSLContext trustAllSslContext;
        try {
            trustAllSslContext = SSLContext.getInstance("SSL");
            trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLSocketFactory trustAllSslSocketFactory = trustAllSslContext.getSocketFactory();
        OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
        builder.sslSocketFactory(trustAllSslSocketFactory, (X509TrustManager)trustAllCerts[0]);
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        this.okHttpClient = builder.build();
    }

    private void setProxy(Proxy proxy) {
        OkHttpClient.Builder builder = this.okHttpClient.newBuilder().proxy(proxy);
        this.okHttpClient = builder.build();
    }

    private void setupTLSProtocol(OkHttpClient.Builder builder) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            System.setProperty("com.ibm.jsse2.overrideDefaultTLS", "true");
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            DelegatingSSLSocketFactory sslSocketFactory = new DelegatingSSLSocketFactory(sslContext.getSocketFactory()){

                @Override
                protected SSLSocket configureSocket(SSLSocket socket) throws IOException {
                    socket.setEnabledProtocols(new String[]{TlsVersion.TLS_1_0.javaName(), TlsVersion.TLS_1_1.javaName(), TlsVersion.TLS_1_2.javaName()});
                    return socket;
                }
            };
            builder.sslSocketFactory(sslSocketFactory, trustManager);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.SEVERE, "The cryptographic algorithm requested is not available in the environment.", e);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.SEVERE, "Error using the keystore.", e);
        }
        catch (KeyManagementException e) {
            LOG.log(Level.SEVERE, "Error initializing the SSL Context.", e);
        }
    }

    public OkHttpClient createHttpClient() {
        OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
        this.addCookieJar(builder);
        return builder.build();
    }

    public OkHttpClient configureClient(HttpConfigOptions options) {
        if (options != null) {
            if (options.shouldDisableSslVerification()) {
                this.disableSslVerification();
            }
            if (options.getProxy() != null) {
                this.setProxy(options.getProxy());
            }
        }
        return this.okHttpClient;
    }
}

